/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.GeoDistanceType;
import co.elastic.clients.elasticsearch._types.GeoLocation;
import co.elastic.clients.elasticsearch._types.query_dsl.GeoValidationMethod;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GeoDistanceQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    private final GeoLocation location;
    private final String distance;
    @Nullable
    private final GeoDistanceType distanceType;
    @Nullable
    private final GeoValidationMethod validationMethod;
    public static final JsonpDeserializer<GeoDistanceQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoDistanceQuery::setupGeoDistanceQueryDeserializer);

    private GeoDistanceQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.location = ApiTypeHelper.requireNonNull(builder.location, this, "location");
        this.distance = ApiTypeHelper.requireNonNull(builder.distance, this, "distance");
        this.distanceType = builder.distanceType;
        this.validationMethod = builder.validationMethod;
    }

    public static GeoDistanceQuery of(Function<Builder, ObjectBuilder<GeoDistanceQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.GeoDistance;
    }

    public final String field() {
        return this.field;
    }

    public final GeoLocation location() {
        return this.location;
    }

    public final String distance() {
        return this.distance;
    }

    @Nullable
    public final GeoDistanceType distanceType() {
        return this.distanceType;
    }

    @Nullable
    public final GeoValidationMethod validationMethod() {
        return this.validationMethod;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey(this.field);
        this.location.serialize(generator, mapper);
        super.serializeInternal(generator, mapper);
        generator.writeKey("distance");
        generator.write(this.distance);
        if (this.distanceType != null) {
            generator.writeKey("distance_type");
            this.distanceType.serialize(generator, mapper);
        }
        if (this.validationMethod != null) {
            generator.writeKey("validation_method");
            this.validationMethod.serialize(generator, mapper);
        }
    }

    protected static void setupGeoDistanceQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::distance, JsonpDeserializer.stringDeserializer(), "distance");
        op.add(Builder::distanceType, GeoDistanceType._DESERIALIZER, "distance_type");
        op.add(Builder::validationMethod, GeoValidationMethod._DESERIALIZER, "validation_method");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            builder.field((String)name);
            builder.location(GeoLocation._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoDistanceQuery> {
        private String field;
        private GeoLocation location;
        private String distance;
        @Nullable
        private GeoDistanceType distanceType;
        @Nullable
        private GeoValidationMethod validationMethod;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder location(GeoLocation value) {
            this.location = value;
            return this;
        }

        public final Builder location(Function<GeoLocation.Builder, ObjectBuilder<GeoLocation>> fn) {
            return this.location(fn.apply(new GeoLocation.Builder()).build());
        }

        public final Builder distance(String value) {
            this.distance = value;
            return this;
        }

        public final Builder distanceType(@Nullable GeoDistanceType value) {
            this.distanceType = value;
            return this;
        }

        public final Builder validationMethod(@Nullable GeoValidationMethod value) {
            this.validationMethod = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoDistanceQuery build() {
            this._checkSingleUse();
            return new GeoDistanceQuery(this);
        }
    }
}

