/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.OnScriptError;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IpProperty
extends DocValuesPropertyBase
implements PropertyVariant {
    @Nullable
    private final Double boost;
    @Nullable
    private final Boolean index;
    @Nullable
    private final Boolean ignoreMalformed;
    @Nullable
    private final String nullValue;
    @Nullable
    private final OnScriptError onScriptError;
    @Nullable
    private final Script script;
    @Nullable
    private final Boolean timeSeriesDimension;
    public static final JsonpDeserializer<IpProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IpProperty::setupIpPropertyDeserializer);

    private IpProperty(Builder builder) {
        super(builder);
        this.boost = builder.boost;
        this.index = builder.index;
        this.ignoreMalformed = builder.ignoreMalformed;
        this.nullValue = builder.nullValue;
        this.onScriptError = builder.onScriptError;
        this.script = builder.script;
        this.timeSeriesDimension = builder.timeSeriesDimension;
    }

    public static IpProperty of(Function<Builder, ObjectBuilder<IpProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Ip;
    }

    @Nullable
    public final Double boost() {
        return this.boost;
    }

    @Nullable
    public final Boolean index() {
        return this.index;
    }

    @Nullable
    public final Boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Nullable
    public final String nullValue() {
        return this.nullValue;
    }

    @Nullable
    public final OnScriptError onScriptError() {
        return this.onScriptError;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final Boolean timeSeriesDimension() {
        return this.timeSeriesDimension;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "ip");
        super.serializeInternal(generator, mapper);
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write(this.boost.doubleValue());
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
        if (this.ignoreMalformed != null) {
            generator.writeKey("ignore_malformed");
            generator.write(this.ignoreMalformed.booleanValue());
        }
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue);
        }
        if (this.onScriptError != null) {
            generator.writeKey("on_script_error");
            this.onScriptError.serialize(generator, mapper);
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.timeSeriesDimension != null) {
            generator.writeKey("time_series_dimension");
            generator.write(this.timeSeriesDimension.booleanValue());
        }
    }

    protected static void setupIpPropertyDeserializer(ObjectDeserializer<Builder> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::boost, JsonpDeserializer.doubleDeserializer(), "boost");
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index");
        op.add(Builder::ignoreMalformed, JsonpDeserializer.booleanDeserializer(), "ignore_malformed");
        op.add(Builder::nullValue, JsonpDeserializer.stringDeserializer(), "null_value");
        op.add(Builder::onScriptError, OnScriptError._DESERIALIZER, "on_script_error");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::timeSeriesDimension, JsonpDeserializer.booleanDeserializer(), "time_series_dimension");
        op.ignore("type");
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IpProperty> {
        @Nullable
        private Double boost;
        @Nullable
        private Boolean index;
        @Nullable
        private Boolean ignoreMalformed;
        @Nullable
        private String nullValue;
        @Nullable
        private OnScriptError onScriptError;
        @Nullable
        private Script script;
        @Nullable
        private Boolean timeSeriesDimension;

        public final Builder boost(@Nullable Double value) {
            this.boost = value;
            return this;
        }

        public final Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        public final Builder ignoreMalformed(@Nullable Boolean value) {
            this.ignoreMalformed = value;
            return this;
        }

        public final Builder nullValue(@Nullable String value) {
            this.nullValue = value;
            return this;
        }

        public final Builder onScriptError(@Nullable OnScriptError value) {
            this.onScriptError = value;
            return this;
        }

        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final Builder timeSeriesDimension(@Nullable Boolean value) {
            this.timeSeriesDimension = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IpProperty build() {
            this._checkSingleUse();
            return new IpProperty(this);
        }
    }
}

