/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FilteringAdvancedSnippet
implements JsonpSerializable {
    @Nullable
    private final DateTime createdAt;
    @Nullable
    private final DateTime updatedAt;
    private final Map<String, JsonData> value;
    public static final JsonpDeserializer<FilteringAdvancedSnippet> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FilteringAdvancedSnippet::setupFilteringAdvancedSnippetDeserializer);

    private FilteringAdvancedSnippet(Builder builder) {
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.value = ApiTypeHelper.unmodifiableRequired(builder.value, (Object)this, "value");
    }

    public static FilteringAdvancedSnippet of(Function<Builder, ObjectBuilder<FilteringAdvancedSnippet>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DateTime createdAt() {
        return this.createdAt;
    }

    @Nullable
    public final DateTime updatedAt() {
        return this.updatedAt;
    }

    public final Map<String, JsonData> value() {
        return this.value;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.createdAt != null) {
            generator.writeKey("created_at");
            this.createdAt.serialize(generator, mapper);
        }
        if (this.updatedAt != null) {
            generator.writeKey("updated_at");
            this.updatedAt.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.value)) {
            generator.writeKey("value");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.value.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFilteringAdvancedSnippetDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::createdAt, DateTime._DESERIALIZER, "created_at");
        op.add(Builder::updatedAt, DateTime._DESERIALIZER, "updated_at");
        op.add(Builder::value, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "value");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FilteringAdvancedSnippet> {
        @Nullable
        private DateTime createdAt;
        @Nullable
        private DateTime updatedAt;
        private Map<String, JsonData> value;

        public final Builder createdAt(@Nullable DateTime value) {
            this.createdAt = value;
            return this;
        }

        public final Builder updatedAt(@Nullable DateTime value) {
            this.updatedAt = value;
            return this;
        }

        public final Builder value(Map<String, JsonData> map) {
            this.value = Builder._mapPutAll(this.value, map);
            return this;
        }

        public final Builder value(String key, JsonData value) {
            this.value = Builder._mapPut(this.value, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FilteringAdvancedSnippet build() {
            this._checkSingleUse();
            return new FilteringAdvancedSnippet(this);
        }
    }
}

