/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.migration;

import co.elastic.clients.elasticsearch.migration.deprecations.Deprecation;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class DeprecationsResponse
implements JsonpSerializable {
    private final List<Deprecation> clusterSettings;
    private final Map<String, List<Deprecation>> indexSettings;
    private final Map<String, List<Deprecation>> dataStreams;
    private final List<Deprecation> nodeSettings;
    private final List<Deprecation> mlSettings;
    public static final JsonpDeserializer<DeprecationsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DeprecationsResponse::setupDeprecationsResponseDeserializer);

    private DeprecationsResponse(Builder builder) {
        this.clusterSettings = ApiTypeHelper.unmodifiableRequired(builder.clusterSettings, (Object)this, "clusterSettings");
        this.indexSettings = ApiTypeHelper.unmodifiableRequired(builder.indexSettings, (Object)this, "indexSettings");
        this.dataStreams = ApiTypeHelper.unmodifiableRequired(builder.dataStreams, (Object)this, "dataStreams");
        this.nodeSettings = ApiTypeHelper.unmodifiableRequired(builder.nodeSettings, (Object)this, "nodeSettings");
        this.mlSettings = ApiTypeHelper.unmodifiableRequired(builder.mlSettings, (Object)this, "mlSettings");
    }

    public static DeprecationsResponse of(Function<Builder, ObjectBuilder<DeprecationsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Deprecation> clusterSettings() {
        return this.clusterSettings;
    }

    public final Map<String, List<Deprecation>> indexSettings() {
        return this.indexSettings;
    }

    public final Map<String, List<Deprecation>> dataStreams() {
        return this.dataStreams;
    }

    public final List<Deprecation> nodeSettings() {
        return this.nodeSettings;
    }

    public final List<Deprecation> mlSettings() {
        return this.mlSettings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.clusterSettings)) {
            generator.writeKey("cluster_settings");
            generator.writeStartArray();
            for (Deprecation deprecation : this.clusterSettings) {
                deprecation.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.indexSettings)) {
            generator.writeKey("index_settings");
            generator.writeStartObject();
            for (Map.Entry entry : this.indexSettings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.writeStartArray();
                if (entry.getValue() != null) {
                    for (Deprecation item1 : (List)entry.getValue()) {
                        item1.serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.dataStreams)) {
            generator.writeKey("data_streams");
            generator.writeStartObject();
            for (Map.Entry entry : this.dataStreams.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.writeStartArray();
                if (entry.getValue() != null) {
                    for (Deprecation item1 : (List)entry.getValue()) {
                        item1.serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.nodeSettings)) {
            generator.writeKey("node_settings");
            generator.writeStartArray();
            for (Deprecation deprecation : this.nodeSettings) {
                deprecation.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.mlSettings)) {
            generator.writeKey("ml_settings");
            generator.writeStartArray();
            for (Deprecation deprecation : this.mlSettings) {
                deprecation.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDeprecationsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::clusterSettings, JsonpDeserializer.arrayDeserializer(Deprecation._DESERIALIZER), "cluster_settings");
        op.add(Builder::indexSettings, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(Deprecation._DESERIALIZER)), "index_settings");
        op.add(Builder::dataStreams, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(Deprecation._DESERIALIZER)), "data_streams");
        op.add(Builder::nodeSettings, JsonpDeserializer.arrayDeserializer(Deprecation._DESERIALIZER), "node_settings");
        op.add(Builder::mlSettings, JsonpDeserializer.arrayDeserializer(Deprecation._DESERIALIZER), "ml_settings");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DeprecationsResponse> {
        private List<Deprecation> clusterSettings;
        private Map<String, List<Deprecation>> indexSettings;
        private Map<String, List<Deprecation>> dataStreams;
        private List<Deprecation> nodeSettings;
        private List<Deprecation> mlSettings;

        public final Builder clusterSettings(List<Deprecation> list) {
            this.clusterSettings = Builder._listAddAll(this.clusterSettings, list);
            return this;
        }

        public final Builder clusterSettings(Deprecation value, Deprecation ... values) {
            this.clusterSettings = Builder._listAdd(this.clusterSettings, value, values);
            return this;
        }

        public final Builder clusterSettings(Function<Deprecation.Builder, ObjectBuilder<Deprecation>> fn) {
            return this.clusterSettings(fn.apply(new Deprecation.Builder()).build(), new Deprecation[0]);
        }

        public final Builder indexSettings(Map<String, List<Deprecation>> map) {
            this.indexSettings = Builder._mapPutAll(this.indexSettings, map);
            return this;
        }

        public final Builder indexSettings(String key, List<Deprecation> value) {
            this.indexSettings = Builder._mapPut(this.indexSettings, key, value);
            return this;
        }

        public final Builder dataStreams(Map<String, List<Deprecation>> map) {
            this.dataStreams = Builder._mapPutAll(this.dataStreams, map);
            return this;
        }

        public final Builder dataStreams(String key, List<Deprecation> value) {
            this.dataStreams = Builder._mapPut(this.dataStreams, key, value);
            return this;
        }

        public final Builder nodeSettings(List<Deprecation> list) {
            this.nodeSettings = Builder._listAddAll(this.nodeSettings, list);
            return this;
        }

        public final Builder nodeSettings(Deprecation value, Deprecation ... values) {
            this.nodeSettings = Builder._listAdd(this.nodeSettings, value, values);
            return this;
        }

        public final Builder nodeSettings(Function<Deprecation.Builder, ObjectBuilder<Deprecation>> fn) {
            return this.nodeSettings(fn.apply(new Deprecation.Builder()).build(), new Deprecation[0]);
        }

        public final Builder mlSettings(List<Deprecation> list) {
            this.mlSettings = Builder._listAddAll(this.mlSettings, list);
            return this;
        }

        public final Builder mlSettings(Deprecation value, Deprecation ... values) {
            this.mlSettings = Builder._listAdd(this.mlSettings, value, values);
            return this;
        }

        public final Builder mlSettings(Function<Deprecation.Builder, ObjectBuilder<Deprecation>> fn) {
            return this.mlSettings(fn.apply(new Deprecation.Builder()).build(), new Deprecation[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DeprecationsResponse build() {
            this._checkSingleUse();
            return new DeprecationsResponse(this);
        }
    }
}

