/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DetectionRule;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DetectorUpdate
implements JsonpSerializable {
    private final int detectorIndex;
    @Nullable
    private final String description;
    private final List<DetectionRule> customRules;
    public static final JsonpDeserializer<DetectorUpdate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DetectorUpdate::setupDetectorUpdateDeserializer);

    private DetectorUpdate(Builder builder) {
        this.detectorIndex = ApiTypeHelper.requireNonNull(builder.detectorIndex, this, "detectorIndex");
        this.description = builder.description;
        this.customRules = ApiTypeHelper.unmodifiable(builder.customRules);
    }

    public static DetectorUpdate of(Function<Builder, ObjectBuilder<DetectorUpdate>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int detectorIndex() {
        return this.detectorIndex;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final List<DetectionRule> customRules() {
        return this.customRules;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("detector_index");
        generator.write(this.detectorIndex);
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (ApiTypeHelper.isDefined(this.customRules)) {
            generator.writeKey("custom_rules");
            generator.writeStartArray();
            for (DetectionRule item0 : this.customRules) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDetectorUpdateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::detectorIndex, JsonpDeserializer.integerDeserializer(), "detector_index");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::customRules, JsonpDeserializer.arrayDeserializer(DetectionRule._DESERIALIZER), "custom_rules");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DetectorUpdate> {
        private Integer detectorIndex;
        @Nullable
        private String description;
        @Nullable
        private List<DetectionRule> customRules;

        public final Builder detectorIndex(int value) {
            this.detectorIndex = value;
            return this;
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder customRules(List<DetectionRule> list) {
            this.customRules = Builder._listAddAll(this.customRules, list);
            return this;
        }

        public final Builder customRules(DetectionRule value, DetectionRule ... values) {
            this.customRules = Builder._listAdd(this.customRules, value, values);
            return this;
        }

        public final Builder customRules(Function<DetectionRule.Builder, ObjectBuilder<DetectionRule>> fn) {
            return this.customRules(fn.apply(new DetectionRule.Builder()).build(), new DetectionRule[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DetectorUpdate build() {
            this._checkSingleUse();
            return new DetectorUpdate(this);
        }
    }
}

