/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch._types.NodeRole;
import co.elastic.clients.elasticsearch.indices.stats.ShardStats;
import co.elastic.clients.elasticsearch.nodes.AdaptiveSelection;
import co.elastic.clients.elasticsearch.nodes.Breaker;
import co.elastic.clients.elasticsearch.nodes.Discovery;
import co.elastic.clients.elasticsearch.nodes.FileSystem;
import co.elastic.clients.elasticsearch.nodes.Http;
import co.elastic.clients.elasticsearch.nodes.IndexingPressure;
import co.elastic.clients.elasticsearch.nodes.Ingest;
import co.elastic.clients.elasticsearch.nodes.Jvm;
import co.elastic.clients.elasticsearch.nodes.OperatingSystem;
import co.elastic.clients.elasticsearch.nodes.Process;
import co.elastic.clients.elasticsearch.nodes.ScriptCache;
import co.elastic.clients.elasticsearch.nodes.Scripting;
import co.elastic.clients.elasticsearch.nodes.ThreadCount;
import co.elastic.clients.elasticsearch.nodes.Transport;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Stats
implements JsonpSerializable {
    private final Map<String, AdaptiveSelection> adaptiveSelection;
    private final Map<String, Breaker> breakers;
    @Nullable
    private final FileSystem fs;
    @Nullable
    private final String host;
    @Nullable
    private final Http http;
    @Nullable
    private final Ingest ingest;
    private final List<String> ip;
    @Nullable
    private final Jvm jvm;
    @Nullable
    private final String name;
    @Nullable
    private final OperatingSystem os;
    @Nullable
    private final Process process;
    private final List<NodeRole> roles;
    @Nullable
    private final Scripting script;
    private final Map<String, List<ScriptCache>> scriptCache;
    private final Map<String, ThreadCount> threadPool;
    @Nullable
    private final Long timestamp;
    @Nullable
    private final Transport transport;
    @Nullable
    private final String transportAddress;
    private final Map<String, String> attributes;
    @Nullable
    private final Discovery discovery;
    @Nullable
    private final IndexingPressure indexingPressure;
    @Nullable
    private final ShardStats indices;
    public static final JsonpDeserializer<Stats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Stats::setupStatsDeserializer);

    private Stats(Builder builder) {
        this.adaptiveSelection = ApiTypeHelper.unmodifiable(builder.adaptiveSelection);
        this.breakers = ApiTypeHelper.unmodifiable(builder.breakers);
        this.fs = builder.fs;
        this.host = builder.host;
        this.http = builder.http;
        this.ingest = builder.ingest;
        this.ip = ApiTypeHelper.unmodifiable(builder.ip);
        this.jvm = builder.jvm;
        this.name = builder.name;
        this.os = builder.os;
        this.process = builder.process;
        this.roles = ApiTypeHelper.unmodifiable(builder.roles);
        this.script = builder.script;
        this.scriptCache = ApiTypeHelper.unmodifiable(builder.scriptCache);
        this.threadPool = ApiTypeHelper.unmodifiable(builder.threadPool);
        this.timestamp = builder.timestamp;
        this.transport = builder.transport;
        this.transportAddress = builder.transportAddress;
        this.attributes = ApiTypeHelper.unmodifiable(builder.attributes);
        this.discovery = builder.discovery;
        this.indexingPressure = builder.indexingPressure;
        this.indices = builder.indices;
    }

    public static Stats of(Function<Builder, ObjectBuilder<Stats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, AdaptiveSelection> adaptiveSelection() {
        return this.adaptiveSelection;
    }

    public final Map<String, Breaker> breakers() {
        return this.breakers;
    }

    @Nullable
    public final FileSystem fs() {
        return this.fs;
    }

    @Nullable
    public final String host() {
        return this.host;
    }

    @Nullable
    public final Http http() {
        return this.http;
    }

    @Nullable
    public final Ingest ingest() {
        return this.ingest;
    }

    public final List<String> ip() {
        return this.ip;
    }

    @Nullable
    public final Jvm jvm() {
        return this.jvm;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Nullable
    public final OperatingSystem os() {
        return this.os;
    }

    @Nullable
    public final Process process() {
        return this.process;
    }

    public final List<NodeRole> roles() {
        return this.roles;
    }

    @Nullable
    public final Scripting script() {
        return this.script;
    }

    public final Map<String, List<ScriptCache>> scriptCache() {
        return this.scriptCache;
    }

    public final Map<String, ThreadCount> threadPool() {
        return this.threadPool;
    }

    @Nullable
    public final Long timestamp() {
        return this.timestamp;
    }

    @Nullable
    public final Transport transport() {
        return this.transport;
    }

    @Nullable
    public final String transportAddress() {
        return this.transportAddress;
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    @Nullable
    public final Discovery discovery() {
        return this.discovery;
    }

    @Nullable
    public final IndexingPressure indexingPressure() {
        return this.indexingPressure;
    }

    @Nullable
    public final ShardStats indices() {
        return this.indices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.adaptiveSelection)) {
            generator.writeKey("adaptive_selection");
            generator.writeStartObject();
            for (Map.Entry<String, AdaptiveSelection> entry : this.adaptiveSelection.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.breakers)) {
            generator.writeKey("breakers");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.breakers.entrySet()) {
                generator.writeKey(entry.getKey());
                ((Breaker)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.fs != null) {
            generator.writeKey("fs");
            this.fs.serialize(generator, mapper);
        }
        if (this.host != null) {
            generator.writeKey("host");
            generator.write(this.host);
        }
        if (this.http != null) {
            generator.writeKey("http");
            this.http.serialize(generator, mapper);
        }
        if (this.ingest != null) {
            generator.writeKey("ingest");
            this.ingest.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.ip)) {
            generator.writeKey("ip");
            generator.writeStartArray();
            for (String string : this.ip) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.jvm != null) {
            generator.writeKey("jvm");
            this.jvm.serialize(generator, mapper);
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (this.os != null) {
            generator.writeKey("os");
            this.os.serialize(generator, mapper);
        }
        if (this.process != null) {
            generator.writeKey("process");
            this.process.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (NodeRole nodeRole : this.roles) {
                nodeRole.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.scriptCache)) {
            generator.writeKey("script_cache");
            generator.writeStartObject();
            for (Map.Entry entry : this.scriptCache.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.writeStartArray();
                if (entry.getValue() != null) {
                    for (ScriptCache item1 : (List)entry.getValue()) {
                        item1.serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.threadPool)) {
            generator.writeKey("thread_pool");
            generator.writeStartObject();
            for (Map.Entry entry : this.threadPool.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((ThreadCount)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.timestamp != null) {
            generator.writeKey("timestamp");
            generator.write(this.timestamp.longValue());
        }
        if (this.transport != null) {
            generator.writeKey("transport");
            this.transport.serialize(generator, mapper);
        }
        if (this.transportAddress != null) {
            generator.writeKey("transport_address");
            generator.write(this.transportAddress);
        }
        if (ApiTypeHelper.isDefined(this.attributes)) {
            generator.writeKey("attributes");
            generator.writeStartObject();
            for (Map.Entry entry : this.attributes.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (this.discovery != null) {
            generator.writeKey("discovery");
            this.discovery.serialize(generator, mapper);
        }
        if (this.indexingPressure != null) {
            generator.writeKey("indexing_pressure");
            this.indexingPressure.serialize(generator, mapper);
        }
        if (this.indices != null) {
            generator.writeKey("indices");
            this.indices.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::adaptiveSelection, JsonpDeserializer.stringMapDeserializer(AdaptiveSelection._DESERIALIZER), "adaptive_selection");
        op.add(Builder::breakers, JsonpDeserializer.stringMapDeserializer(Breaker._DESERIALIZER), "breakers");
        op.add(Builder::fs, FileSystem._DESERIALIZER, "fs");
        op.add(Builder::host, JsonpDeserializer.stringDeserializer(), "host");
        op.add(Builder::http, Http._DESERIALIZER, "http");
        op.add(Builder::ingest, Ingest._DESERIALIZER, "ingest");
        op.add(Builder::ip, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ip");
        op.add(Builder::jvm, Jvm._DESERIALIZER, "jvm");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::os, OperatingSystem._DESERIALIZER, "os");
        op.add(Builder::process, Process._DESERIALIZER, "process");
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(NodeRole._DESERIALIZER), "roles");
        op.add(Builder::script, Scripting._DESERIALIZER, "script");
        op.add(Builder::scriptCache, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(ScriptCache._DESERIALIZER)), "script_cache");
        op.add(Builder::threadPool, JsonpDeserializer.stringMapDeserializer(ThreadCount._DESERIALIZER), "thread_pool");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
        op.add(Builder::transport, Transport._DESERIALIZER, "transport");
        op.add(Builder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address");
        op.add(Builder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes");
        op.add(Builder::discovery, Discovery._DESERIALIZER, "discovery");
        op.add(Builder::indexingPressure, IndexingPressure._DESERIALIZER, "indexing_pressure");
        op.add(Builder::indices, ShardStats._DESERIALIZER, "indices");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Stats> {
        @Nullable
        private Map<String, AdaptiveSelection> adaptiveSelection;
        @Nullable
        private Map<String, Breaker> breakers;
        @Nullable
        private FileSystem fs;
        @Nullable
        private String host;
        @Nullable
        private Http http;
        @Nullable
        private Ingest ingest;
        @Nullable
        private List<String> ip;
        @Nullable
        private Jvm jvm;
        @Nullable
        private String name;
        @Nullable
        private OperatingSystem os;
        @Nullable
        private Process process;
        @Nullable
        private List<NodeRole> roles;
        @Nullable
        private Scripting script;
        @Nullable
        private Map<String, List<ScriptCache>> scriptCache;
        @Nullable
        private Map<String, ThreadCount> threadPool;
        @Nullable
        private Long timestamp;
        @Nullable
        private Transport transport;
        @Nullable
        private String transportAddress;
        @Nullable
        private Map<String, String> attributes;
        @Nullable
        private Discovery discovery;
        @Nullable
        private IndexingPressure indexingPressure;
        @Nullable
        private ShardStats indices;

        public final Builder adaptiveSelection(Map<String, AdaptiveSelection> map) {
            this.adaptiveSelection = Builder._mapPutAll(this.adaptiveSelection, map);
            return this;
        }

        public final Builder adaptiveSelection(String key, AdaptiveSelection value) {
            this.adaptiveSelection = Builder._mapPut(this.adaptiveSelection, key, value);
            return this;
        }

        public final Builder adaptiveSelection(String key, Function<AdaptiveSelection.Builder, ObjectBuilder<AdaptiveSelection>> fn) {
            return this.adaptiveSelection(key, fn.apply(new AdaptiveSelection.Builder()).build());
        }

        public final Builder breakers(Map<String, Breaker> map) {
            this.breakers = Builder._mapPutAll(this.breakers, map);
            return this;
        }

        public final Builder breakers(String key, Breaker value) {
            this.breakers = Builder._mapPut(this.breakers, key, value);
            return this;
        }

        public final Builder breakers(String key, Function<Breaker.Builder, ObjectBuilder<Breaker>> fn) {
            return this.breakers(key, fn.apply(new Breaker.Builder()).build());
        }

        public final Builder fs(@Nullable FileSystem value) {
            this.fs = value;
            return this;
        }

        public final Builder fs(Function<FileSystem.Builder, ObjectBuilder<FileSystem>> fn) {
            return this.fs(fn.apply(new FileSystem.Builder()).build());
        }

        public final Builder host(@Nullable String value) {
            this.host = value;
            return this;
        }

        public final Builder http(@Nullable Http value) {
            this.http = value;
            return this;
        }

        public final Builder http(Function<Http.Builder, ObjectBuilder<Http>> fn) {
            return this.http(fn.apply(new Http.Builder()).build());
        }

        public final Builder ingest(@Nullable Ingest value) {
            this.ingest = value;
            return this;
        }

        public final Builder ingest(Function<Ingest.Builder, ObjectBuilder<Ingest>> fn) {
            return this.ingest(fn.apply(new Ingest.Builder()).build());
        }

        public final Builder ip(List<String> list) {
            this.ip = Builder._listAddAll(this.ip, list);
            return this;
        }

        public final Builder ip(String value, String ... values) {
            this.ip = Builder._listAdd(this.ip, value, values);
            return this;
        }

        public final Builder jvm(@Nullable Jvm value) {
            this.jvm = value;
            return this;
        }

        public final Builder jvm(Function<Jvm.Builder, ObjectBuilder<Jvm>> fn) {
            return this.jvm(fn.apply(new Jvm.Builder()).build());
        }

        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public final Builder os(@Nullable OperatingSystem value) {
            this.os = value;
            return this;
        }

        public final Builder os(Function<OperatingSystem.Builder, ObjectBuilder<OperatingSystem>> fn) {
            return this.os(fn.apply(new OperatingSystem.Builder()).build());
        }

        public final Builder process(@Nullable Process value) {
            this.process = value;
            return this;
        }

        public final Builder process(Function<Process.Builder, ObjectBuilder<Process>> fn) {
            return this.process(fn.apply(new Process.Builder()).build());
        }

        public final Builder roles(List<NodeRole> list) {
            this.roles = Builder._listAddAll(this.roles, list);
            return this;
        }

        public final Builder roles(NodeRole value, NodeRole ... values) {
            this.roles = Builder._listAdd(this.roles, value, values);
            return this;
        }

        public final Builder script(@Nullable Scripting value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Scripting.Builder, ObjectBuilder<Scripting>> fn) {
            return this.script(fn.apply(new Scripting.Builder()).build());
        }

        public final Builder scriptCache(Map<String, List<ScriptCache>> map) {
            this.scriptCache = Builder._mapPutAll(this.scriptCache, map);
            return this;
        }

        public final Builder scriptCache(String key, List<ScriptCache> value) {
            this.scriptCache = Builder._mapPut(this.scriptCache, key, value);
            return this;
        }

        public final Builder threadPool(Map<String, ThreadCount> map) {
            this.threadPool = Builder._mapPutAll(this.threadPool, map);
            return this;
        }

        public final Builder threadPool(String key, ThreadCount value) {
            this.threadPool = Builder._mapPut(this.threadPool, key, value);
            return this;
        }

        public final Builder threadPool(String key, Function<ThreadCount.Builder, ObjectBuilder<ThreadCount>> fn) {
            return this.threadPool(key, fn.apply(new ThreadCount.Builder()).build());
        }

        public final Builder timestamp(@Nullable Long value) {
            this.timestamp = value;
            return this;
        }

        public final Builder transport(@Nullable Transport value) {
            this.transport = value;
            return this;
        }

        public final Builder transport(Function<Transport.Builder, ObjectBuilder<Transport>> fn) {
            return this.transport(fn.apply(new Transport.Builder()).build());
        }

        public final Builder transportAddress(@Nullable String value) {
            this.transportAddress = value;
            return this;
        }

        public final Builder attributes(Map<String, String> map) {
            this.attributes = Builder._mapPutAll(this.attributes, map);
            return this;
        }

        public final Builder attributes(String key, String value) {
            this.attributes = Builder._mapPut(this.attributes, key, value);
            return this;
        }

        public final Builder discovery(@Nullable Discovery value) {
            this.discovery = value;
            return this;
        }

        public final Builder discovery(Function<Discovery.Builder, ObjectBuilder<Discovery>> fn) {
            return this.discovery(fn.apply(new Discovery.Builder()).build());
        }

        public final Builder indexingPressure(@Nullable IndexingPressure value) {
            this.indexingPressure = value;
            return this;
        }

        public final Builder indexingPressure(Function<IndexingPressure.Builder, ObjectBuilder<IndexingPressure>> fn) {
            return this.indexingPressure(fn.apply(new IndexingPressure.Builder()).build());
        }

        public final Builder indices(@Nullable ShardStats value) {
            this.indices = value;
            return this;
        }

        public final Builder indices(Function<ShardStats.Builder, ObjectBuilder<ShardStats>> fn) {
            return this.indices(fn.apply(new ShardStats.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Stats build() {
            this._checkSingleUse();
            return new Stats(this);
        }
    }
}

