/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher.execute_watch;

import co.elastic.clients.elasticsearch.watcher.Condition;
import co.elastic.clients.elasticsearch.watcher.ExecutionResult;
import co.elastic.clients.elasticsearch.watcher.ExecutionStatus;
import co.elastic.clients.elasticsearch.watcher.Input;
import co.elastic.clients.elasticsearch.watcher.TriggerEventResult;
import co.elastic.clients.elasticsearch.watcher.WatchStatus;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class WatchRecord
implements JsonpSerializable {
    private final Condition condition;
    private final Input input;
    private final List<String> messages;
    private final Map<String, JsonData> metadata;
    private final String node;
    private final ExecutionResult result;
    private final ExecutionStatus state;
    private final TriggerEventResult triggerEvent;
    private final String user;
    private final String watchId;
    @Nullable
    private final WatchStatus status;
    public static final JsonpDeserializer<WatchRecord> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WatchRecord::setupWatchRecordDeserializer);

    private WatchRecord(Builder builder) {
        this.condition = ApiTypeHelper.requireNonNull(builder.condition, this, "condition");
        this.input = ApiTypeHelper.requireNonNull(builder.input, this, "input");
        this.messages = ApiTypeHelper.unmodifiableRequired(builder.messages, (Object)this, "messages");
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.node = ApiTypeHelper.requireNonNull(builder.node, this, "node");
        this.result = ApiTypeHelper.requireNonNull(builder.result, this, "result");
        this.state = ApiTypeHelper.requireNonNull(builder.state, this, "state");
        this.triggerEvent = ApiTypeHelper.requireNonNull(builder.triggerEvent, this, "triggerEvent");
        this.user = ApiTypeHelper.requireNonNull(builder.user, this, "user");
        this.watchId = ApiTypeHelper.requireNonNull(builder.watchId, this, "watchId");
        this.status = builder.status;
    }

    public static WatchRecord of(Function<Builder, ObjectBuilder<WatchRecord>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Condition condition() {
        return this.condition;
    }

    public final Input input() {
        return this.input;
    }

    public final List<String> messages() {
        return this.messages;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    public final String node() {
        return this.node;
    }

    public final ExecutionResult result() {
        return this.result;
    }

    public final ExecutionStatus state() {
        return this.state;
    }

    public final TriggerEventResult triggerEvent() {
        return this.triggerEvent;
    }

    public final String user() {
        return this.user;
    }

    public final String watchId() {
        return this.watchId;
    }

    @Nullable
    public final WatchStatus status() {
        return this.status;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("condition");
        this.condition.serialize(generator, mapper);
        generator.writeKey("input");
        this.input.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.messages)) {
            generator.writeKey("messages");
            generator.writeStartArray();
            for (String string : this.messages) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.metadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("node");
        generator.write(this.node);
        generator.writeKey("result");
        this.result.serialize(generator, mapper);
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
        generator.writeKey("trigger_event");
        this.triggerEvent.serialize(generator, mapper);
        generator.writeKey("user");
        generator.write(this.user);
        generator.writeKey("watch_id");
        generator.write(this.watchId);
        if (this.status != null) {
            generator.writeKey("status");
            this.status.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupWatchRecordDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::condition, Condition._DESERIALIZER, "condition");
        op.add(Builder::input, Input._DESERIALIZER, "input");
        op.add(Builder::messages, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "messages");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node");
        op.add(Builder::result, ExecutionResult._DESERIALIZER, "result");
        op.add(Builder::state, ExecutionStatus._DESERIALIZER, "state");
        op.add(Builder::triggerEvent, TriggerEventResult._DESERIALIZER, "trigger_event");
        op.add(Builder::user, JsonpDeserializer.stringDeserializer(), "user");
        op.add(Builder::watchId, JsonpDeserializer.stringDeserializer(), "watch_id");
        op.add(Builder::status, WatchStatus._DESERIALIZER, "status");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<WatchRecord> {
        private Condition condition;
        private Input input;
        private List<String> messages;
        @Nullable
        private Map<String, JsonData> metadata;
        private String node;
        private ExecutionResult result;
        private ExecutionStatus state;
        private TriggerEventResult triggerEvent;
        private String user;
        private String watchId;
        @Nullable
        private WatchStatus status;

        public final Builder condition(Condition value) {
            this.condition = value;
            return this;
        }

        public final Builder condition(Function<Condition.Builder, ObjectBuilder<Condition>> fn) {
            return this.condition(fn.apply(new Condition.Builder()).build());
        }

        public final Builder input(Input value) {
            this.input = value;
            return this;
        }

        public final Builder input(Function<Input.Builder, ObjectBuilder<Input>> fn) {
            return this.input(fn.apply(new Input.Builder()).build());
        }

        public final Builder messages(List<String> list) {
            this.messages = Builder._listAddAll(this.messages, list);
            return this;
        }

        public final Builder messages(String value, String ... values) {
            this.messages = Builder._listAdd(this.messages, value, values);
            return this;
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        public final Builder node(String value) {
            this.node = value;
            return this;
        }

        public final Builder result(ExecutionResult value) {
            this.result = value;
            return this;
        }

        public final Builder result(Function<ExecutionResult.Builder, ObjectBuilder<ExecutionResult>> fn) {
            return this.result(fn.apply(new ExecutionResult.Builder()).build());
        }

        public final Builder state(ExecutionStatus value) {
            this.state = value;
            return this;
        }

        public final Builder triggerEvent(TriggerEventResult value) {
            this.triggerEvent = value;
            return this;
        }

        public final Builder triggerEvent(Function<TriggerEventResult.Builder, ObjectBuilder<TriggerEventResult>> fn) {
            return this.triggerEvent(fn.apply(new TriggerEventResult.Builder()).build());
        }

        public final Builder user(String value) {
            this.user = value;
            return this;
        }

        public final Builder watchId(String value) {
            this.watchId = value;
            return this;
        }

        public final Builder status(@Nullable WatchStatus value) {
            this.status = value;
            return this;
        }

        public final Builder status(Function<WatchStatus.Builder, ObjectBuilder<WatchStatus>> fn) {
            return this.status(fn.apply(new WatchStatus.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WatchRecord build() {
            this._checkSingleUse();
            return new WatchRecord(this);
        }
    }
}

