/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.endpoints;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.transport.JsonEndpoint;
import co.elastic.clients.transport.endpoints.EndpointBase;
import java.util.Map;
import java.util.function.Function;
import org.apache.http.client.utils.URLEncodedUtils;

public class SimpleEndpoint<RequestT, ResponseT>
extends EndpointBase<RequestT, ResponseT>
implements JsonEndpoint<RequestT, ResponseT, ErrorResponse> {
    private final JsonpDeserializer<ResponseT> responseParser;

    public SimpleEndpoint(String id, Function<RequestT, String> method, Function<RequestT, String> requestUrl, Function<RequestT, Map<String, String>> queryParameters, Function<RequestT, Map<String, String>> headers, Function<RequestT, Object> body, JsonpDeserializer<ResponseT> responseParser) {
        super(id, method, requestUrl, queryParameters, headers, body);
        this.responseParser = responseParser;
    }

    public SimpleEndpoint(String id, Function<RequestT, String> method, Function<RequestT, String> requestUrl, Function<RequestT, Map<String, String>> queryParameters, Function<RequestT, Map<String, String>> headers, boolean hasResponseBody, JsonpDeserializer<ResponseT> responseParser) {
        this(id, method, requestUrl, queryParameters, headers, hasResponseBody ? SimpleEndpoint.returnSelf() : SimpleEndpoint.returnNull(), responseParser);
    }

    @Override
    public JsonpDeserializer<ResponseT> responseDeserializer() {
        return this.responseParser;
    }

    @Override
    public JsonpDeserializer<ErrorResponse> errorDeserializer(int statusCode) {
        return ErrorResponse._DESERIALIZER;
    }

    @Override
    public <NewResponseT> SimpleEndpoint<RequestT, NewResponseT> withResponseDeserializer(JsonpDeserializer<NewResponseT> newResponseParser) {
        return new SimpleEndpoint<RequestT, NewResponseT>(this.id, this.method, this.requestUrl, this.queryParameters, this.headers, this.body, newResponseParser);
    }

    public static RuntimeException noPathTemplateFound(String what) {
        return new RuntimeException("Could not find a request " + what + " with this set of properties. Please check the API documentation, or raise an issue if this should be a valid request.");
    }

    public static void pathEncode(String src, StringBuilder dest) {
        dest.append(URLEncodedUtils.formatSegments((String[])new String[]{src}).substring(1));
    }
}

