/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.slm.GetLifecycleResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GetLifecycleRequest
extends RequestBase {
    private final List<String> policyId;
    public static final Endpoint<GetLifecycleRequest, GetLifecycleResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetLifecycleRequest, GetLifecycleResponse>("es/slm.get_lifecycle", request -> "GET", request -> {
        boolean _policyId = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.policyId())) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_slm");
            buf.append("/policy");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.policyId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_slm");
            buf.append("/policy");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, GetLifecycleResponse._DESERIALIZER);

    private GetLifecycleRequest(Builder builder) {
        this.policyId = ApiTypeHelper.unmodifiable(builder.policyId);
    }

    public static GetLifecycleRequest of(Function<Builder, ObjectBuilder<GetLifecycleRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> policyId() {
        return this.policyId;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetLifecycleRequest> {
        @Nullable
        private List<String> policyId;

        public final Builder policyId(List<String> list) {
            this.policyId = Builder._listAddAll(this.policyId, list);
            return this;
        }

        public final Builder policyId(String value, String ... values) {
            this.policyId = Builder._listAdd(this.policyId, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetLifecycleRequest build() {
            this._checkSingleUse();
            return new GetLifecycleRequest(this);
        }
    }
}

