/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.modify_data_stream;

import co.elastic.clients.elasticsearch.indices.modify_data_stream.Action;
import co.elastic.clients.elasticsearch.indices.modify_data_stream.ActionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class IndexAndDataStreamAction
implements ActionVariant,
JsonpSerializable {
    private final String index;
    private final String dataStream;
    public static final JsonpDeserializer<IndexAndDataStreamAction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexAndDataStreamAction::setupIndexAndDataStreamActionDeserializer);

    private IndexAndDataStreamAction(Builder builder) {
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.dataStream = ApiTypeHelper.requireNonNull(builder.dataStream, this, "dataStream");
    }

    public static IndexAndDataStreamAction of(Function<Builder, ObjectBuilder<IndexAndDataStreamAction>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Action.Kind _actionKind() {
        return Action.Kind.RemoveBackingIndex;
    }

    public final String index() {
        return this.index;
    }

    public final String dataStream() {
        return this.dataStream;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index");
        generator.write(this.index);
        generator.writeKey("data_stream");
        generator.write(this.dataStream);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupIndexAndDataStreamActionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::dataStream, JsonpDeserializer.stringDeserializer(), "data_stream");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IndexAndDataStreamAction> {
        private String index;
        private String dataStream;

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder dataStream(String value) {
            this.dataStream = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndexAndDataStreamAction build() {
            this._checkSingleUse();
            return new IndexAndDataStreamAction(this);
        }
    }
}

