/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.esql;

import co.elastic.clients.elasticsearch.esql.TableValuesVariant;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class TableValues
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<TableValues> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TableValues::setupTableValuesDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public TableValues(TableValuesVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._tableValuesKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private TableValues(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static TableValues of(Function<Builder, ObjectBuilder<TableValues>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isInteger() {
        return this._kind == Kind.Integer;
    }

    public List<List<Integer>> integer() {
        return (List)TaggedUnionUtils.get(this, Kind.Integer);
    }

    public boolean isKeyword() {
        return this._kind == Kind.Keyword;
    }

    public List<List<String>> keyword() {
        return (List)TaggedUnionUtils.get(this, Kind.Keyword);
    }

    public boolean isLong() {
        return this._kind == Kind.Long;
    }

    public List<List<Long>> long_() {
        return (List)TaggedUnionUtils.get(this, Kind.Long);
    }

    public boolean isDouble() {
        return this._kind == Kind.Double;
    }

    public List<List<Double>> double_() {
        return (List)TaggedUnionUtils.get(this, Kind.Double);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Integer: {
                    generator.writeStartArray();
                    for (List item0 : (List)this._value) {
                        generator.writeStartArray();
                        if (item0 != null) {
                            for (Integer item1 : item0) {
                                generator.write(item1.intValue());
                            }
                        }
                        generator.writeEnd();
                    }
                    generator.writeEnd();
                    break;
                }
                case Keyword: {
                    generator.writeStartArray();
                    for (List item0 : (List)this._value) {
                        generator.writeStartArray();
                        if (item0 != null) {
                            for (String item1 : item0) {
                                generator.write(item1);
                            }
                        }
                        generator.writeEnd();
                    }
                    generator.writeEnd();
                    break;
                }
                case Long: {
                    generator.writeStartArray();
                    for (List item0 : (List)this._value) {
                        generator.writeStartArray();
                        if (item0 != null) {
                            for (Long item1 : item0) {
                                generator.write(item1.longValue());
                            }
                        }
                        generator.writeEnd();
                    }
                    generator.writeEnd();
                    break;
                }
                case Double: {
                    generator.writeStartArray();
                    for (List item0 : (List)this._value) {
                        generator.writeStartArray();
                        if (item0 != null) {
                            for (Double item1 : item0) {
                                generator.write(item1.doubleValue());
                            }
                        }
                        generator.writeEnd();
                    }
                    generator.writeEnd();
                }
            }
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTableValuesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::integer, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.integerDeserializer())), "integer");
        op.add(Builder::keyword, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "keyword");
        op.add(Builder::long_, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.longDeserializer())), "long");
        op.add(Builder::double_, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer())), "double");
    }

    public static enum Kind implements JsonEnum
    {
        Integer("integer"),
        Keyword("keyword"),
        Long("long"),
        Double("double");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TableValues> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<TableValues> integer(List<List<Integer>> v) {
            this._kind = Kind.Integer;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TableValues> keyword(List<List<String>> v) {
            this._kind = Kind.Keyword;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TableValues> long_(List<List<Long>> v) {
            this._kind = Kind.Long;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TableValues> double_(List<List<Double>> v) {
            this._kind = Kind.Double;
            this._value = v;
            return this;
        }

        @Override
        public TableValues build() {
            this._checkSingleUse();
            return new TableValues(this);
        }
    }
}

