/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregationSourceVariant;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeDateHistogramAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeGeoTileGridAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeHistogramAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeTermsAggregation;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class CompositeAggregationSource
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<CompositeAggregationSource> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompositeAggregationSource::setupCompositeAggregationSourceDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public CompositeAggregationSource(CompositeAggregationSourceVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._compositeAggregationSourceKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private CompositeAggregationSource(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static CompositeAggregationSource of(Function<Builder, ObjectBuilder<CompositeAggregationSource>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isTerms() {
        return this._kind == Kind.Terms;
    }

    public CompositeTermsAggregation terms() {
        return (CompositeTermsAggregation)TaggedUnionUtils.get(this, Kind.Terms);
    }

    public boolean isHistogram() {
        return this._kind == Kind.Histogram;
    }

    public CompositeHistogramAggregation histogram() {
        return (CompositeHistogramAggregation)TaggedUnionUtils.get(this, Kind.Histogram);
    }

    public boolean isDateHistogram() {
        return this._kind == Kind.DateHistogram;
    }

    public CompositeDateHistogramAggregation dateHistogram() {
        return (CompositeDateHistogramAggregation)TaggedUnionUtils.get(this, Kind.DateHistogram);
    }

    public boolean isGeotileGrid() {
        return this._kind == Kind.GeotileGrid;
    }

    public CompositeGeoTileGridAggregation geotileGrid() {
        return (CompositeGeoTileGridAggregation)TaggedUnionUtils.get(this, Kind.GeotileGrid);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCompositeAggregationSourceDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::terms, CompositeTermsAggregation._DESERIALIZER, "terms");
        op.add(Builder::histogram, CompositeHistogramAggregation._DESERIALIZER, "histogram");
        op.add(Builder::dateHistogram, CompositeDateHistogramAggregation._DESERIALIZER, "date_histogram");
        op.add(Builder::geotileGrid, CompositeGeoTileGridAggregation._DESERIALIZER, "geotile_grid");
    }

    public static enum Kind implements JsonEnum
    {
        Terms("terms"),
        Histogram("histogram"),
        DateHistogram("date_histogram"),
        GeotileGrid("geotile_grid");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CompositeAggregationSource> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<CompositeAggregationSource> terms(CompositeTermsAggregation v) {
            this._kind = Kind.Terms;
            this._value = v;
            return this;
        }

        public ObjectBuilder<CompositeAggregationSource> terms(Function<CompositeTermsAggregation.Builder, ObjectBuilder<CompositeTermsAggregation>> fn) {
            return this.terms(fn.apply(new CompositeTermsAggregation.Builder()).build());
        }

        public ObjectBuilder<CompositeAggregationSource> histogram(CompositeHistogramAggregation v) {
            this._kind = Kind.Histogram;
            this._value = v;
            return this;
        }

        public ObjectBuilder<CompositeAggregationSource> histogram(Function<CompositeHistogramAggregation.Builder, ObjectBuilder<CompositeHistogramAggregation>> fn) {
            return this.histogram(fn.apply(new CompositeHistogramAggregation.Builder()).build());
        }

        public ObjectBuilder<CompositeAggregationSource> dateHistogram(CompositeDateHistogramAggregation v) {
            this._kind = Kind.DateHistogram;
            this._value = v;
            return this;
        }

        public ObjectBuilder<CompositeAggregationSource> dateHistogram(Function<CompositeDateHistogramAggregation.Builder, ObjectBuilder<CompositeDateHistogramAggregation>> fn) {
            return this.dateHistogram(fn.apply(new CompositeDateHistogramAggregation.Builder()).build());
        }

        public ObjectBuilder<CompositeAggregationSource> geotileGrid(CompositeGeoTileGridAggregation v) {
            this._kind = Kind.GeotileGrid;
            this._value = v;
            return this;
        }

        public ObjectBuilder<CompositeAggregationSource> geotileGrid(Function<CompositeGeoTileGridAggregation.Builder, ObjectBuilder<CompositeGeoTileGridAggregation>> fn) {
            return this.geotileGrid(fn.apply(new CompositeGeoTileGridAggregation.Builder()).build());
        }

        @Override
        public CompositeAggregationSource build() {
            this._checkSingleUse();
            return new CompositeAggregationSource(this);
        }
    }
}

