/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.ApiClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch.transform.DeleteTransformRequest;
import co.elastic.clients.elasticsearch.transform.DeleteTransformResponse;
import co.elastic.clients.elasticsearch.transform.GetNodeStatsRequest;
import co.elastic.clients.elasticsearch.transform.GetNodeStatsResponse;
import co.elastic.clients.elasticsearch.transform.GetTransformRequest;
import co.elastic.clients.elasticsearch.transform.GetTransformResponse;
import co.elastic.clients.elasticsearch.transform.GetTransformStatsRequest;
import co.elastic.clients.elasticsearch.transform.GetTransformStatsResponse;
import co.elastic.clients.elasticsearch.transform.PreviewTransformRequest;
import co.elastic.clients.elasticsearch.transform.PreviewTransformResponse;
import co.elastic.clients.elasticsearch.transform.PutTransformRequest;
import co.elastic.clients.elasticsearch.transform.PutTransformResponse;
import co.elastic.clients.elasticsearch.transform.ResetTransformRequest;
import co.elastic.clients.elasticsearch.transform.ResetTransformResponse;
import co.elastic.clients.elasticsearch.transform.ScheduleNowTransformRequest;
import co.elastic.clients.elasticsearch.transform.ScheduleNowTransformResponse;
import co.elastic.clients.elasticsearch.transform.SetUpgradeModeRequest;
import co.elastic.clients.elasticsearch.transform.SetUpgradeModeResponse;
import co.elastic.clients.elasticsearch.transform.StartTransformRequest;
import co.elastic.clients.elasticsearch.transform.StartTransformResponse;
import co.elastic.clients.elasticsearch.transform.StopTransformRequest;
import co.elastic.clients.elasticsearch.transform.StopTransformResponse;
import co.elastic.clients.elasticsearch.transform.UpdateTransformRequest;
import co.elastic.clients.elasticsearch.transform.UpdateTransformResponse;
import co.elastic.clients.elasticsearch.transform.UpgradeTransformsRequest;
import co.elastic.clients.elasticsearch.transform.UpgradeTransformsResponse;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.JsonEndpoint;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.endpoints.EndpointWithResponseMapperAttr;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ElasticsearchTransformClient
extends ApiClient<ElasticsearchTransport, ElasticsearchTransformClient> {
    public ElasticsearchTransformClient(ElasticsearchTransport transport) {
        super(transport, null);
    }

    public ElasticsearchTransformClient(ElasticsearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    @Override
    public ElasticsearchTransformClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new ElasticsearchTransformClient((ElasticsearchTransport)this.transport, transportOptions);
    }

    public DeleteTransformResponse deleteTransform(DeleteTransformRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)DeleteTransformRequest._ENDPOINT;
        return (DeleteTransformResponse)((ElasticsearchTransport)this.transport).performRequest(request, endpoint, this.transportOptions);
    }

    public final DeleteTransformResponse deleteTransform(Function<DeleteTransformRequest.Builder, ObjectBuilder<DeleteTransformRequest>> fn) throws IOException, ElasticsearchException {
        return this.deleteTransform(fn.apply(new DeleteTransformRequest.Builder()).build());
    }

    public GetNodeStatsResponse getNodeStats() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequest(GetNodeStatsRequest._INSTANCE, GetNodeStatsRequest._ENDPOINT, this.transportOptions);
    }

    public GetTransformResponse getTransform(GetTransformRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)GetTransformRequest._ENDPOINT;
        return (GetTransformResponse)((ElasticsearchTransport)this.transport).performRequest(request, endpoint, this.transportOptions);
    }

    public final GetTransformResponse getTransform(Function<GetTransformRequest.Builder, ObjectBuilder<GetTransformRequest>> fn) throws IOException, ElasticsearchException {
        return this.getTransform(fn.apply(new GetTransformRequest.Builder()).build());
    }

    public GetTransformResponse getTransform() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequest(new GetTransformRequest.Builder().build(), GetTransformRequest._ENDPOINT, this.transportOptions);
    }

    public GetTransformStatsResponse getTransformStats(GetTransformStatsRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)GetTransformStatsRequest._ENDPOINT;
        return (GetTransformStatsResponse)((ElasticsearchTransport)this.transport).performRequest(request, endpoint, this.transportOptions);
    }

    public final GetTransformStatsResponse getTransformStats(Function<GetTransformStatsRequest.Builder, ObjectBuilder<GetTransformStatsRequest>> fn) throws IOException, ElasticsearchException {
        return this.getTransformStats(fn.apply(new GetTransformStatsRequest.Builder()).build());
    }

    public <TTransform> PreviewTransformResponse<TTransform> previewTransform(PreviewTransformRequest request, Class<TTransform> tTransformClass) throws IOException, ElasticsearchException {
        JsonEndpoint<Object, Object, ErrorResponse> endpoint = PreviewTransformRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr(endpoint, "co.elastic.clients:Deserializer:transform.preview_transform.Response.TTransform", this.getDeserializer(tTransformClass));
        return (PreviewTransformResponse)((ElasticsearchTransport)this.transport).performRequest(request, endpoint, this.transportOptions);
    }

    public final <TTransform> PreviewTransformResponse<TTransform> previewTransform(Function<PreviewTransformRequest.Builder, ObjectBuilder<PreviewTransformRequest>> fn, Class<TTransform> tTransformClass) throws IOException, ElasticsearchException {
        return this.previewTransform(fn.apply(new PreviewTransformRequest.Builder()).build(), tTransformClass);
    }

    public PreviewTransformResponse<Void> previewTransform(PreviewTransformRequest request) throws IOException, ElasticsearchException {
        SimpleEndpoint<PreviewTransformRequest, ?> endpoint = PreviewTransformRequest._ENDPOINT;
        return (PreviewTransformResponse)((ElasticsearchTransport)this.transport).performRequest(request, endpoint, this.transportOptions);
    }

    public final PreviewTransformResponse<Void> previewTransform(Function<PreviewTransformRequest.Builder, ObjectBuilder<PreviewTransformRequest>> fn) throws IOException, ElasticsearchException {
        return this.previewTransform(fn.apply(new PreviewTransformRequest.Builder()).build(), Void.class);
    }

    public <TTransform> PreviewTransformResponse<TTransform> previewTransform(PreviewTransformRequest request, Type tTransformType) throws IOException, ElasticsearchException {
        JsonEndpoint<Object, Object, ErrorResponse> endpoint = PreviewTransformRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr(endpoint, "co.elastic.clients:Deserializer:transform.preview_transform.Response.TTransform", this.getDeserializer(tTransformType));
        return (PreviewTransformResponse)((ElasticsearchTransport)this.transport).performRequest(request, endpoint, this.transportOptions);
    }

    public final <TTransform> PreviewTransformResponse<TTransform> previewTransform(Function<PreviewTransformRequest.Builder, ObjectBuilder<PreviewTransformRequest>> fn, Type tTransformType) throws IOException, ElasticsearchException {
        return this.previewTransform(fn.apply(new PreviewTransformRequest.Builder()).build(), tTransformType);
    }

    public PutTransformResponse putTransform(PutTransformRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)PutTransformRequest._ENDPOINT;
        return (PutTransformResponse)((ElasticsearchTransport)this.transport).performRequest(request, endpoint, this.transportOptions);
    }

    public final PutTransformResponse putTransform(Function<PutTransformRequest.Builder, ObjectBuilder<PutTransformRequest>> fn) throws IOException, ElasticsearchException {
        return this.putTransform(fn.apply(new PutTransformRequest.Builder()).build());
    }

    public ResetTransformResponse resetTransform(ResetTransformRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)ResetTransformRequest._ENDPOINT;
        return (ResetTransformResponse)((ElasticsearchTransport)this.transport).performRequest(request, endpoint, this.transportOptions);
    }

    public final ResetTransformResponse resetTransform(Function<ResetTransformRequest.Builder, ObjectBuilder<ResetTransformRequest>> fn) throws IOException, ElasticsearchException {
        return this.resetTransform(fn.apply(new ResetTransformRequest.Builder()).build());
    }

    public ScheduleNowTransformResponse scheduleNowTransform(ScheduleNowTransformRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)ScheduleNowTransformRequest._ENDPOINT;
        return (ScheduleNowTransformResponse)((ElasticsearchTransport)this.transport).performRequest(request, endpoint, this.transportOptions);
    }

    public final ScheduleNowTransformResponse scheduleNowTransform(Function<ScheduleNowTransformRequest.Builder, ObjectBuilder<ScheduleNowTransformRequest>> fn) throws IOException, ElasticsearchException {
        return this.scheduleNowTransform(fn.apply(new ScheduleNowTransformRequest.Builder()).build());
    }

    public SetUpgradeModeResponse setUpgradeMode(SetUpgradeModeRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)SetUpgradeModeRequest._ENDPOINT;
        return (SetUpgradeModeResponse)((ElasticsearchTransport)this.transport).performRequest(request, endpoint, this.transportOptions);
    }

    public final SetUpgradeModeResponse setUpgradeMode(Function<SetUpgradeModeRequest.Builder, ObjectBuilder<SetUpgradeModeRequest>> fn) throws IOException, ElasticsearchException {
        return this.setUpgradeMode(fn.apply(new SetUpgradeModeRequest.Builder()).build());
    }

    public SetUpgradeModeResponse setUpgradeMode() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequest(new SetUpgradeModeRequest.Builder().build(), SetUpgradeModeRequest._ENDPOINT, this.transportOptions);
    }

    public StartTransformResponse startTransform(StartTransformRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)StartTransformRequest._ENDPOINT;
        return (StartTransformResponse)((ElasticsearchTransport)this.transport).performRequest(request, endpoint, this.transportOptions);
    }

    public final StartTransformResponse startTransform(Function<StartTransformRequest.Builder, ObjectBuilder<StartTransformRequest>> fn) throws IOException, ElasticsearchException {
        return this.startTransform(fn.apply(new StartTransformRequest.Builder()).build());
    }

    public StopTransformResponse stopTransform(StopTransformRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)StopTransformRequest._ENDPOINT;
        return (StopTransformResponse)((ElasticsearchTransport)this.transport).performRequest(request, endpoint, this.transportOptions);
    }

    public final StopTransformResponse stopTransform(Function<StopTransformRequest.Builder, ObjectBuilder<StopTransformRequest>> fn) throws IOException, ElasticsearchException {
        return this.stopTransform(fn.apply(new StopTransformRequest.Builder()).build());
    }

    public UpdateTransformResponse updateTransform(UpdateTransformRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)UpdateTransformRequest._ENDPOINT;
        return (UpdateTransformResponse)((ElasticsearchTransport)this.transport).performRequest(request, endpoint, this.transportOptions);
    }

    public final UpdateTransformResponse updateTransform(Function<UpdateTransformRequest.Builder, ObjectBuilder<UpdateTransformRequest>> fn) throws IOException, ElasticsearchException {
        return this.updateTransform(fn.apply(new UpdateTransformRequest.Builder()).build());
    }

    public UpgradeTransformsResponse upgradeTransforms(UpgradeTransformsRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)UpgradeTransformsRequest._ENDPOINT;
        return (UpgradeTransformsResponse)((ElasticsearchTransport)this.transport).performRequest(request, endpoint, this.transportOptions);
    }

    public final UpgradeTransformsResponse upgradeTransforms(Function<UpgradeTransformsRequest.Builder, ObjectBuilder<UpgradeTransformsRequest>> fn) throws IOException, ElasticsearchException {
        return this.upgradeTransforms(fn.apply(new UpgradeTransformsRequest.Builder()).build());
    }

    public UpgradeTransformsResponse upgradeTransforms() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequest(new UpgradeTransformsRequest.Builder().build(), UpgradeTransformsRequest._ENDPOINT, this.transportOptions);
    }
}

