/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.CalendarEvent;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GetCalendarEventsResponse
implements JsonpSerializable {
    private final long count;
    private final List<CalendarEvent> events;
    public static final JsonpDeserializer<GetCalendarEventsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetCalendarEventsResponse::setupGetCalendarEventsResponseDeserializer);

    private GetCalendarEventsResponse(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0L);
        this.events = ApiTypeHelper.unmodifiableRequired(builder.events, (Object)this, "events");
    }

    public static GetCalendarEventsResponse of(Function<Builder, ObjectBuilder<GetCalendarEventsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    public final List<CalendarEvent> events() {
        return this.events;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (ApiTypeHelper.isDefined(this.events)) {
            generator.writeKey("events");
            generator.writeStartArray();
            for (CalendarEvent item0 : this.events) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetCalendarEventsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::events, JsonpDeserializer.arrayDeserializer(CalendarEvent._DESERIALIZER), "events");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetCalendarEventsResponse> {
        private Long count;
        private List<CalendarEvent> events;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder events(List<CalendarEvent> list) {
            this.events = Builder._listAddAll(this.events, list);
            return this;
        }

        public final Builder events(CalendarEvent value, CalendarEvent ... values) {
            this.events = Builder._listAdd(this.events, value, values);
            return this;
        }

        public final Builder events(Function<CalendarEvent.Builder, ObjectBuilder<CalendarEvent>> fn) {
            return this.events(fn.apply(new CalendarEvent.Builder()).build(), new CalendarEvent[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetCalendarEventsResponse build() {
            this._checkSingleUse();
            return new GetCalendarEventsResponse(this);
        }
    }
}

