/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class BulkStats
implements JsonpSerializable {
    private final long totalOperations;
    @Nullable
    private final Time totalTime;
    private final long totalTimeInMillis;
    @Nullable
    private final String totalSize;
    private final long totalSizeInBytes;
    @Nullable
    private final Time avgTime;
    private final long avgTimeInMillis;
    @Nullable
    private final String avgSize;
    private final long avgSizeInBytes;
    public static final JsonpDeserializer<BulkStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BulkStats::setupBulkStatsDeserializer);

    private BulkStats(Builder builder) {
        this.totalOperations = ApiTypeHelper.requireNonNull(builder.totalOperations, (Object)this, "totalOperations", 0L);
        this.totalTime = builder.totalTime;
        this.totalTimeInMillis = ApiTypeHelper.requireNonNull(builder.totalTimeInMillis, (Object)this, "totalTimeInMillis", 0L);
        this.totalSize = builder.totalSize;
        this.totalSizeInBytes = ApiTypeHelper.requireNonNull(builder.totalSizeInBytes, (Object)this, "totalSizeInBytes", 0L);
        this.avgTime = builder.avgTime;
        this.avgTimeInMillis = ApiTypeHelper.requireNonNull(builder.avgTimeInMillis, (Object)this, "avgTimeInMillis", 0L);
        this.avgSize = builder.avgSize;
        this.avgSizeInBytes = ApiTypeHelper.requireNonNull(builder.avgSizeInBytes, (Object)this, "avgSizeInBytes", 0L);
    }

    public static BulkStats of(Function<Builder, ObjectBuilder<BulkStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long totalOperations() {
        return this.totalOperations;
    }

    @Nullable
    public final Time totalTime() {
        return this.totalTime;
    }

    public final long totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    @Nullable
    public final String totalSize() {
        return this.totalSize;
    }

    public final long totalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    @Nullable
    public final Time avgTime() {
        return this.avgTime;
    }

    public final long avgTimeInMillis() {
        return this.avgTimeInMillis;
    }

    @Nullable
    public final String avgSize() {
        return this.avgSize;
    }

    public final long avgSizeInBytes() {
        return this.avgSizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total_operations");
        generator.write(this.totalOperations);
        if (this.totalTime != null) {
            generator.writeKey("total_time");
            this.totalTime.serialize(generator, mapper);
        }
        generator.writeKey("total_time_in_millis");
        generator.write(this.totalTimeInMillis);
        if (this.totalSize != null) {
            generator.writeKey("total_size");
            generator.write(this.totalSize);
        }
        generator.writeKey("total_size_in_bytes");
        generator.write(this.totalSizeInBytes);
        if (this.avgTime != null) {
            generator.writeKey("avg_time");
            this.avgTime.serialize(generator, mapper);
        }
        generator.writeKey("avg_time_in_millis");
        generator.write(this.avgTimeInMillis);
        if (this.avgSize != null) {
            generator.writeKey("avg_size");
            generator.write(this.avgSize);
        }
        generator.writeKey("avg_size_in_bytes");
        generator.write(this.avgSizeInBytes);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupBulkStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::totalOperations, JsonpDeserializer.longDeserializer(), "total_operations");
        op.add(Builder::totalTime, Time._DESERIALIZER, "total_time");
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.longDeserializer(), "total_time_in_millis");
        op.add(Builder::totalSize, JsonpDeserializer.stringDeserializer(), "total_size");
        op.add(Builder::totalSizeInBytes, JsonpDeserializer.longDeserializer(), "total_size_in_bytes");
        op.add(Builder::avgTime, Time._DESERIALIZER, "avg_time");
        op.add(Builder::avgTimeInMillis, JsonpDeserializer.longDeserializer(), "avg_time_in_millis");
        op.add(Builder::avgSize, JsonpDeserializer.stringDeserializer(), "avg_size");
        op.add(Builder::avgSizeInBytes, JsonpDeserializer.longDeserializer(), "avg_size_in_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<BulkStats> {
        private Long totalOperations;
        @Nullable
        private Time totalTime;
        private Long totalTimeInMillis;
        @Nullable
        private String totalSize;
        private Long totalSizeInBytes;
        @Nullable
        private Time avgTime;
        private Long avgTimeInMillis;
        @Nullable
        private String avgSize;
        private Long avgSizeInBytes;

        public Builder() {
        }

        private Builder(BulkStats instance) {
            this.totalOperations = instance.totalOperations;
            this.totalTime = instance.totalTime;
            this.totalTimeInMillis = instance.totalTimeInMillis;
            this.totalSize = instance.totalSize;
            this.totalSizeInBytes = instance.totalSizeInBytes;
            this.avgTime = instance.avgTime;
            this.avgTimeInMillis = instance.avgTimeInMillis;
            this.avgSize = instance.avgSize;
            this.avgSizeInBytes = instance.avgSizeInBytes;
        }

        public final Builder totalOperations(long value) {
            this.totalOperations = value;
            return this;
        }

        public final Builder totalTime(@Nullable Time value) {
            this.totalTime = value;
            return this;
        }

        public final Builder totalTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.totalTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder totalTimeInMillis(long value) {
            this.totalTimeInMillis = value;
            return this;
        }

        public final Builder totalSize(@Nullable String value) {
            this.totalSize = value;
            return this;
        }

        public final Builder totalSizeInBytes(long value) {
            this.totalSizeInBytes = value;
            return this;
        }

        public final Builder avgTime(@Nullable Time value) {
            this.avgTime = value;
            return this;
        }

        public final Builder avgTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.avgTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder avgTimeInMillis(long value) {
            this.avgTimeInMillis = value;
            return this;
        }

        public final Builder avgSize(@Nullable String value) {
            this.avgSize = value;
            return this;
        }

        public final Builder avgSizeInBytes(long value) {
            this.avgSizeInBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BulkStats build() {
            this._checkSingleUse();
            return new BulkStats(this);
        }
    }
}

