/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.DiversifyRetrieverTypes;
import co.elastic.clients.elasticsearch._types.QueryVectorBuilder;
import co.elastic.clients.elasticsearch._types.QueryVectorBuilderVariant;
import co.elastic.clients.elasticsearch._types.Retriever;
import co.elastic.clients.elasticsearch._types.RetrieverBase;
import co.elastic.clients.elasticsearch._types.RetrieverVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DiversifyRetriever
extends RetrieverBase
implements RetrieverVariant {
    private final DiversifyRetrieverTypes type;
    private final String field;
    private final Retriever retriever;
    @Nullable
    private final Integer size;
    @Nullable
    private final Integer rankWindowSize;
    private final List<Float> queryVector;
    @Nullable
    private final QueryVectorBuilder queryVectorBuilder;
    @Nullable
    private final Float lambda;
    public static final JsonpDeserializer<DiversifyRetriever> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DiversifyRetriever::setupDiversifyRetrieverDeserializer);

    private DiversifyRetriever(Builder builder) {
        super(builder);
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.retriever = ApiTypeHelper.requireNonNull(builder.retriever, this, "retriever");
        this.size = builder.size;
        this.rankWindowSize = builder.rankWindowSize;
        this.queryVector = ApiTypeHelper.unmodifiable(builder.queryVector);
        this.queryVectorBuilder = builder.queryVectorBuilder;
        this.lambda = builder.lambda;
    }

    public static DiversifyRetriever of(Function<Builder, ObjectBuilder<DiversifyRetriever>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Retriever.Kind _retrieverKind() {
        return Retriever.Kind.Diversify;
    }

    public final DiversifyRetrieverTypes type() {
        return this.type;
    }

    public final String field() {
        return this.field;
    }

    public final Retriever retriever() {
        return this.retriever;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final Integer rankWindowSize() {
        return this.rankWindowSize;
    }

    public final List<Float> queryVector() {
        return this.queryVector;
    }

    @Nullable
    public final QueryVectorBuilder queryVectorBuilder() {
        return this.queryVectorBuilder;
    }

    @Nullable
    public final Float lambda() {
        return this.lambda;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("retriever");
        this.retriever.serialize(generator, mapper);
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (this.rankWindowSize != null) {
            generator.writeKey("rank_window_size");
            generator.write(this.rankWindowSize.intValue());
        }
        if (ApiTypeHelper.isDefined(this.queryVector)) {
            generator.writeKey("query_vector");
            generator.writeStartArray();
            for (Float item0 : this.queryVector) {
                generator.write((double)item0.floatValue());
            }
            generator.writeEnd();
        }
        if (this.queryVectorBuilder != null) {
            generator.writeKey("query_vector_builder");
            this.queryVectorBuilder.serialize(generator, mapper);
        }
        if (this.lambda != null) {
            generator.writeKey("lambda");
            generator.write((double)this.lambda.floatValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDiversifyRetrieverDeserializer(ObjectDeserializer<Builder> op) {
        RetrieverBase.setupRetrieverBaseDeserializer(op);
        op.add(Builder::type, DiversifyRetrieverTypes._DESERIALIZER, "type");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::retriever, Retriever._DESERIALIZER, "retriever");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::rankWindowSize, JsonpDeserializer.integerDeserializer(), "rank_window_size");
        op.add(Builder::queryVector, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.floatDeserializer()), "query_vector");
        op.add(Builder::queryVectorBuilder, QueryVectorBuilder._DESERIALIZER, "query_vector_builder");
        op.add(Builder::lambda, JsonpDeserializer.floatDeserializer(), "lambda");
    }

    public static class Builder
    extends RetrieverBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DiversifyRetriever> {
        private DiversifyRetrieverTypes type;
        private String field;
        private Retriever retriever;
        @Nullable
        private Integer size;
        @Nullable
        private Integer rankWindowSize;
        @Nullable
        private List<Float> queryVector;
        @Nullable
        private QueryVectorBuilder queryVectorBuilder;
        @Nullable
        private Float lambda;

        public Builder() {
        }

        private Builder(DiversifyRetriever instance) {
            this.type = instance.type;
            this.field = instance.field;
            this.retriever = instance.retriever;
            this.size = instance.size;
            this.rankWindowSize = instance.rankWindowSize;
            this.queryVector = instance.queryVector;
            this.queryVectorBuilder = instance.queryVectorBuilder;
            this.lambda = instance.lambda;
        }

        public final Builder type(DiversifyRetrieverTypes value) {
            this.type = value;
            return this;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder retriever(Retriever value) {
            this.retriever = value;
            return this;
        }

        public final Builder retriever(Function<Retriever.Builder, ObjectBuilder<Retriever>> fn) {
            return this.retriever(fn.apply(new Retriever.Builder()).build());
        }

        public final Builder retriever(RetrieverVariant value) {
            this.retriever = value._toRetriever();
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder rankWindowSize(@Nullable Integer value) {
            this.rankWindowSize = value;
            return this;
        }

        public final Builder queryVector(List<Float> list) {
            this.queryVector = Builder._listAddAll(this.queryVector, list);
            return this;
        }

        public final Builder queryVector(Float value, Float ... values) {
            this.queryVector = Builder._listAdd(this.queryVector, value, values);
            return this;
        }

        public final Builder queryVectorBuilder(@Nullable QueryVectorBuilder value) {
            this.queryVectorBuilder = value;
            return this;
        }

        public final Builder queryVectorBuilder(Function<QueryVectorBuilder.Builder, ObjectBuilder<QueryVectorBuilder>> fn) {
            return this.queryVectorBuilder(fn.apply(new QueryVectorBuilder.Builder()).build());
        }

        public final Builder queryVectorBuilder(QueryVectorBuilderVariant value) {
            this.queryVectorBuilder = value._toQueryVectorBuilder();
            return this;
        }

        public final Builder lambda(@Nullable Float value) {
            this.lambda = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DiversifyRetriever build() {
            this._checkSingleUse();
            return new DiversifyRetriever(this);
        }
    }
}

