/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.Retries;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ReindexStatus
implements JsonpSerializable {
    @Nullable
    private final Integer sliceId;
    private final long batches;
    @Nullable
    private final Long created;
    private final long deleted;
    private final long noops;
    private final float requestsPerSecond;
    private final Retries retries;
    @Nullable
    private final Time throttled;
    private final long throttledMillis;
    @Nullable
    private final Time throttledUntil;
    private final long throttledUntilMillis;
    private final long total;
    @Nullable
    private final Long updated;
    private final long versionConflicts;
    @Nullable
    private final String cancelled;
    public static final JsonpDeserializer<ReindexStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReindexStatus::setupReindexStatusDeserializer);

    private ReindexStatus(Builder builder) {
        this.sliceId = builder.sliceId;
        this.batches = ApiTypeHelper.requireNonNull(builder.batches, (Object)this, "batches", 0L);
        this.created = builder.created;
        this.deleted = ApiTypeHelper.requireNonNull(builder.deleted, (Object)this, "deleted", 0L);
        this.noops = ApiTypeHelper.requireNonNull(builder.noops, (Object)this, "noops", 0L);
        this.requestsPerSecond = ApiTypeHelper.requireNonNull(builder.requestsPerSecond, (Object)this, "requestsPerSecond", 0.0f);
        this.retries = ApiTypeHelper.requireNonNull(builder.retries, this, "retries");
        this.throttled = builder.throttled;
        this.throttledMillis = ApiTypeHelper.requireNonNull(builder.throttledMillis, (Object)this, "throttledMillis", 0L);
        this.throttledUntil = builder.throttledUntil;
        this.throttledUntilMillis = ApiTypeHelper.requireNonNull(builder.throttledUntilMillis, (Object)this, "throttledUntilMillis", 0L);
        this.total = ApiTypeHelper.requireNonNull(builder.total, (Object)this, "total", 0L);
        this.updated = builder.updated;
        this.versionConflicts = ApiTypeHelper.requireNonNull(builder.versionConflicts, (Object)this, "versionConflicts", 0L);
        this.cancelled = builder.cancelled;
    }

    public static ReindexStatus of(Function<Builder, ObjectBuilder<ReindexStatus>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer sliceId() {
        return this.sliceId;
    }

    public final long batches() {
        return this.batches;
    }

    @Nullable
    public final Long created() {
        return this.created;
    }

    public final long deleted() {
        return this.deleted;
    }

    public final long noops() {
        return this.noops;
    }

    public final float requestsPerSecond() {
        return this.requestsPerSecond;
    }

    public final Retries retries() {
        return this.retries;
    }

    @Nullable
    public final Time throttled() {
        return this.throttled;
    }

    public final long throttledMillis() {
        return this.throttledMillis;
    }

    @Nullable
    public final Time throttledUntil() {
        return this.throttledUntil;
    }

    public final long throttledUntilMillis() {
        return this.throttledUntilMillis;
    }

    public final long total() {
        return this.total;
    }

    @Nullable
    public final Long updated() {
        return this.updated;
    }

    public final long versionConflicts() {
        return this.versionConflicts;
    }

    @Nullable
    public final String cancelled() {
        return this.cancelled;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.sliceId != null) {
            generator.writeKey("slice_id");
            generator.write(this.sliceId.intValue());
        }
        generator.writeKey("batches");
        generator.write(this.batches);
        if (this.created != null) {
            generator.writeKey("created");
            generator.write(this.created.longValue());
        }
        generator.writeKey("deleted");
        generator.write(this.deleted);
        generator.writeKey("noops");
        generator.write(this.noops);
        generator.writeKey("requests_per_second");
        generator.write((double)this.requestsPerSecond);
        generator.writeKey("retries");
        this.retries.serialize(generator, mapper);
        if (this.throttled != null) {
            generator.writeKey("throttled");
            this.throttled.serialize(generator, mapper);
        }
        generator.writeKey("throttled_millis");
        generator.write(this.throttledMillis);
        if (this.throttledUntil != null) {
            generator.writeKey("throttled_until");
            this.throttledUntil.serialize(generator, mapper);
        }
        generator.writeKey("throttled_until_millis");
        generator.write(this.throttledUntilMillis);
        generator.writeKey("total");
        generator.write(this.total);
        if (this.updated != null) {
            generator.writeKey("updated");
            generator.write(this.updated.longValue());
        }
        generator.writeKey("version_conflicts");
        generator.write(this.versionConflicts);
        if (this.cancelled != null) {
            generator.writeKey("cancelled");
            generator.write(this.cancelled);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupReindexStatusDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::sliceId, JsonpDeserializer.integerDeserializer(), "slice_id");
        op.add(Builder::batches, JsonpDeserializer.longDeserializer(), "batches");
        op.add(Builder::created, JsonpDeserializer.longDeserializer(), "created");
        op.add(Builder::deleted, JsonpDeserializer.longDeserializer(), "deleted");
        op.add(Builder::noops, JsonpDeserializer.longDeserializer(), "noops");
        op.add(Builder::requestsPerSecond, JsonpDeserializer.floatDeserializer(), "requests_per_second");
        op.add(Builder::retries, Retries._DESERIALIZER, "retries");
        op.add(Builder::throttled, Time._DESERIALIZER, "throttled");
        op.add(Builder::throttledMillis, JsonpDeserializer.longDeserializer(), "throttled_millis");
        op.add(Builder::throttledUntil, Time._DESERIALIZER, "throttled_until");
        op.add(Builder::throttledUntilMillis, JsonpDeserializer.longDeserializer(), "throttled_until_millis");
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
        op.add(Builder::updated, JsonpDeserializer.longDeserializer(), "updated");
        op.add(Builder::versionConflicts, JsonpDeserializer.longDeserializer(), "version_conflicts");
        op.add(Builder::cancelled, JsonpDeserializer.stringDeserializer(), "cancelled");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ReindexStatus> {
        @Nullable
        private Integer sliceId;
        private Long batches;
        @Nullable
        private Long created;
        private Long deleted;
        private Long noops;
        private Float requestsPerSecond;
        private Retries retries;
        @Nullable
        private Time throttled;
        private Long throttledMillis;
        @Nullable
        private Time throttledUntil;
        private Long throttledUntilMillis;
        private Long total;
        @Nullable
        private Long updated;
        private Long versionConflicts;
        @Nullable
        private String cancelled;

        public Builder() {
        }

        private Builder(ReindexStatus instance) {
            this.sliceId = instance.sliceId;
            this.batches = instance.batches;
            this.created = instance.created;
            this.deleted = instance.deleted;
            this.noops = instance.noops;
            this.requestsPerSecond = Float.valueOf(instance.requestsPerSecond);
            this.retries = instance.retries;
            this.throttled = instance.throttled;
            this.throttledMillis = instance.throttledMillis;
            this.throttledUntil = instance.throttledUntil;
            this.throttledUntilMillis = instance.throttledUntilMillis;
            this.total = instance.total;
            this.updated = instance.updated;
            this.versionConflicts = instance.versionConflicts;
            this.cancelled = instance.cancelled;
        }

        public final Builder sliceId(@Nullable Integer value) {
            this.sliceId = value;
            return this;
        }

        public final Builder batches(long value) {
            this.batches = value;
            return this;
        }

        public final Builder created(@Nullable Long value) {
            this.created = value;
            return this;
        }

        public final Builder deleted(long value) {
            this.deleted = value;
            return this;
        }

        public final Builder noops(long value) {
            this.noops = value;
            return this;
        }

        public final Builder requestsPerSecond(float value) {
            this.requestsPerSecond = Float.valueOf(value);
            return this;
        }

        public final Builder retries(Retries value) {
            this.retries = value;
            return this;
        }

        public final Builder retries(Function<Retries.Builder, ObjectBuilder<Retries>> fn) {
            return this.retries(fn.apply(new Retries.Builder()).build());
        }

        public final Builder throttled(@Nullable Time value) {
            this.throttled = value;
            return this;
        }

        public final Builder throttled(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.throttled(fn.apply(new Time.Builder()).build());
        }

        public final Builder throttledMillis(long value) {
            this.throttledMillis = value;
            return this;
        }

        public final Builder throttledUntil(@Nullable Time value) {
            this.throttledUntil = value;
            return this;
        }

        public final Builder throttledUntil(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.throttledUntil(fn.apply(new Time.Builder()).build());
        }

        public final Builder throttledUntilMillis(long value) {
            this.throttledUntilMillis = value;
            return this;
        }

        public final Builder total(long value) {
            this.total = value;
            return this;
        }

        public final Builder updated(@Nullable Long value) {
            this.updated = value;
            return this;
        }

        public final Builder versionConflicts(long value) {
            this.versionConflicts = value;
            return this;
        }

        public final Builder cancelled(@Nullable String value) {
            this.cancelled = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ReindexStatus build() {
            this._checkSingleUse();
            return new ReindexStatus(this);
        }
    }
}

