/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ArrayPercentilesItem
implements JsonpSerializable {
    private final double key;
    @Nullable
    private final Double value;
    @Nullable
    private final String valueAsString;
    public static final JsonpDeserializer<ArrayPercentilesItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ArrayPercentilesItem::setupArrayPercentilesItemDeserializer);

    private ArrayPercentilesItem(Builder builder) {
        this.key = ApiTypeHelper.requireNonNull(builder.key, (Object)this, "key", 0.0);
        this.value = builder.value;
        this.valueAsString = builder.valueAsString;
    }

    public static ArrayPercentilesItem of(Function<Builder, ObjectBuilder<ArrayPercentilesItem>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final double key() {
        return this.key;
    }

    @Nullable
    public final Double value() {
        return this.value;
    }

    @Nullable
    public final String valueAsString() {
        return this.valueAsString;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("key");
        generator.write(this.key);
        if (this.value != null) {
            generator.writeKey("value");
            generator.write(this.value.doubleValue());
        }
        if (this.valueAsString != null) {
            generator.writeKey("value_as_string");
            generator.write(this.valueAsString);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupArrayPercentilesItemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::key, JsonpDeserializer.doubleDeserializer(), "key");
        op.add(Builder::value, JsonpDeserializer.doubleDeserializer(), "value");
        op.add(Builder::valueAsString, JsonpDeserializer.stringDeserializer(), "value_as_string");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ArrayPercentilesItem> {
        private Double key;
        @Nullable
        private Double value;
        @Nullable
        private String valueAsString;

        public Builder() {
        }

        private Builder(ArrayPercentilesItem instance) {
            this.key = instance.key;
            this.value = instance.value;
            this.valueAsString = instance.valueAsString;
        }

        public final Builder key(double value) {
            this.key = value;
            return this;
        }

        public final Builder value(@Nullable Double value) {
            this.value = value;
            return this;
        }

        public final Builder valueAsString(@Nullable String value) {
            this.valueAsString = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ArrayPercentilesItem build() {
            this._checkSingleUse();
            return new ArrayPercentilesItem(this);
        }
    }
}

