/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class BucketCorrelationFunctionCountCorrelationIndicator
implements JsonpSerializable {
    private final int docCount;
    private final List<Double> expectations;
    private final List<Double> fractions;
    public static final JsonpDeserializer<BucketCorrelationFunctionCountCorrelationIndicator> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BucketCorrelationFunctionCountCorrelationIndicator::setupBucketCorrelationFunctionCountCorrelationIndicatorDeserializer);

    private BucketCorrelationFunctionCountCorrelationIndicator(Builder builder) {
        this.docCount = ApiTypeHelper.requireNonNull(builder.docCount, (Object)this, "docCount", 0);
        this.expectations = ApiTypeHelper.unmodifiableRequired(builder.expectations, (Object)this, "expectations");
        this.fractions = ApiTypeHelper.unmodifiable(builder.fractions);
    }

    public static BucketCorrelationFunctionCountCorrelationIndicator of(Function<Builder, ObjectBuilder<BucketCorrelationFunctionCountCorrelationIndicator>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int docCount() {
        return this.docCount;
    }

    public final List<Double> expectations() {
        return this.expectations;
    }

    public final List<Double> fractions() {
        return this.fractions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("doc_count");
        generator.write(this.docCount);
        if (ApiTypeHelper.isDefined(this.expectations)) {
            generator.writeKey("expectations");
            generator.writeStartArray();
            for (Double item0 : this.expectations) {
                generator.write(item0.doubleValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.fractions)) {
            generator.writeKey("fractions");
            generator.writeStartArray();
            for (Double item0 : this.fractions) {
                generator.write(item0.doubleValue());
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupBucketCorrelationFunctionCountCorrelationIndicatorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::docCount, JsonpDeserializer.integerDeserializer(), "doc_count");
        op.add(Builder::expectations, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "expectations");
        op.add(Builder::fractions, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "fractions");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<BucketCorrelationFunctionCountCorrelationIndicator> {
        private Integer docCount;
        private List<Double> expectations;
        @Nullable
        private List<Double> fractions;

        public Builder() {
        }

        private Builder(BucketCorrelationFunctionCountCorrelationIndicator instance) {
            this.docCount = instance.docCount;
            this.expectations = instance.expectations;
            this.fractions = instance.fractions;
        }

        public final Builder docCount(int value) {
            this.docCount = value;
            return this;
        }

        public final Builder expectations(List<Double> list) {
            this.expectations = Builder._listAddAll(this.expectations, list);
            return this;
        }

        public final Builder expectations(Double value, Double ... values) {
            this.expectations = Builder._listAdd(this.expectations, value, values);
            return this;
        }

        public final Builder fractions(List<Double> list) {
            this.fractions = Builder._listAddAll(this.fractions, list);
            return this;
        }

        public final Builder fractions(Double value, Double ... values) {
            this.fractions = Builder._listAdd(this.fractions, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BucketCorrelationFunctionCountCorrelationIndicator build() {
            this._checkSingleUse();
            return new BucketCorrelationFunctionCountCorrelationIndicator(this);
        }
    }
}

