/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateBase;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateVariant;
import co.elastic.clients.elasticsearch._types.aggregations.ChangePointBucket;
import co.elastic.clients.elasticsearch._types.aggregations.ChangeType;
import co.elastic.clients.elasticsearch._types.aggregations.ChangeTypeVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ChangePointAggregate
extends AggregateBase
implements AggregateVariant {
    private final ChangeType type;
    @Nullable
    private final ChangePointBucket bucket;
    public static final JsonpDeserializer<ChangePointAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ChangePointAggregate::setupChangePointAggregateDeserializer);

    private ChangePointAggregate(Builder builder) {
        super(builder);
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.bucket = builder.bucket;
    }

    public static ChangePointAggregate of(Function<Builder, ObjectBuilder<ChangePointAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.ChangePoint;
    }

    public final ChangeType type() {
        return this.type;
    }

    @Nullable
    public final ChangePointBucket bucket() {
        return this.bucket;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
        if (this.bucket != null) {
            generator.writeKey("bucket");
            this.bucket.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupChangePointAggregateDeserializer(ObjectDeserializer<Builder> op) {
        AggregateBase.setupAggregateBaseDeserializer(op);
        op.add(Builder::type, ChangeType._DESERIALIZER, "type");
        op.add(Builder::bucket, ChangePointBucket._DESERIALIZER, "bucket");
    }

    public static class Builder
    extends AggregateBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ChangePointAggregate> {
        private ChangeType type;
        @Nullable
        private ChangePointBucket bucket;

        public Builder() {
        }

        private Builder(ChangePointAggregate instance) {
            this.type = instance.type;
            this.bucket = instance.bucket;
        }

        public final Builder type(ChangeType value) {
            this.type = value;
            return this;
        }

        public final Builder type(Function<ChangeType.Builder, ObjectBuilder<ChangeType>> fn) {
            return this.type(fn.apply(new ChangeType.Builder()).build());
        }

        public final Builder type(ChangeTypeVariant value) {
            this.type = value._toChangeType();
            return this;
        }

        public final Builder bucket(@Nullable ChangePointBucket value) {
            this.bucket = value;
            return this;
        }

        public final Builder bucket(Function<ChangePointBucket.Builder, ObjectBuilder<ChangePointBucket>> fn) {
            return this.bucket(fn.apply(new ChangePointBucket.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ChangePointAggregate build() {
            this._checkSingleUse();
            return new ChangePointAggregate(this);
        }
    }
}

