/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class WeightedAverageValue
implements JsonpSerializable {
    @Nullable
    private final String field;
    @Nullable
    private final Double missing;
    @Nullable
    private final Script script;
    public static final JsonpDeserializer<WeightedAverageValue> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WeightedAverageValue::setupWeightedAverageValueDeserializer);

    private WeightedAverageValue(Builder builder) {
        this.field = builder.field;
        this.missing = builder.missing;
        this.script = builder.script;
    }

    public static WeightedAverageValue of(Function<Builder, ObjectBuilder<WeightedAverageValue>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Double missing() {
        return this.missing;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            generator.write(this.missing.doubleValue());
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupWeightedAverageValueDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::missing, JsonpDeserializer.doubleDeserializer(), "missing");
        op.add(Builder::script, Script._DESERIALIZER, "script");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<WeightedAverageValue> {
        @Nullable
        private String field;
        @Nullable
        private Double missing;
        @Nullable
        private Script script;

        public Builder() {
        }

        private Builder(WeightedAverageValue instance) {
            this.field = instance.field;
            this.missing = instance.missing;
            this.script = instance.script;
        }

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder missing(@Nullable Double value) {
            this.missing = value;
            return this;
        }

        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WeightedAverageValue build() {
            this._checkSingleUse();
            return new WeightedAverageValue(this);
        }
    }
}

