/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.DelimitedPayloadEncoding;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DelimitedPayloadTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    @Nullable
    private final String delimiter;
    @Nullable
    private final DelimitedPayloadEncoding encoding;
    public static final JsonpDeserializer<DelimitedPayloadTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DelimitedPayloadTokenFilter::setupDelimitedPayloadTokenFilterDeserializer);

    private DelimitedPayloadTokenFilter(Builder builder) {
        super(builder);
        this.delimiter = builder.delimiter;
        this.encoding = builder.encoding;
    }

    public static DelimitedPayloadTokenFilter of(Function<Builder, ObjectBuilder<DelimitedPayloadTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.DelimitedPayload;
    }

    @Nullable
    public final String delimiter() {
        return this.delimiter;
    }

    @Nullable
    public final DelimitedPayloadEncoding encoding() {
        return this.encoding;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "delimited_payload");
        super.serializeInternal(generator, mapper);
        if (this.delimiter != null) {
            generator.writeKey("delimiter");
            generator.write(this.delimiter);
        }
        if (this.encoding != null) {
            generator.writeKey("encoding");
            this.encoding.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDelimitedPayloadTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::delimiter, JsonpDeserializer.stringDeserializer(), "delimiter");
        op.add(Builder::encoding, DelimitedPayloadEncoding._DESERIALIZER, "encoding");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DelimitedPayloadTokenFilter> {
        @Nullable
        private String delimiter;
        @Nullable
        private DelimitedPayloadEncoding encoding;

        public Builder() {
        }

        private Builder(DelimitedPayloadTokenFilter instance) {
            this.delimiter = instance.delimiter;
            this.encoding = instance.encoding;
        }

        public final Builder delimiter(@Nullable String value) {
            this.delimiter = value;
            return this;
        }

        public final Builder encoding(@Nullable DelimitedPayloadEncoding value) {
            this.encoding = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DelimitedPayloadTokenFilter build() {
            this._checkSingleUse();
            return new DelimitedPayloadTokenFilter(this);
        }
    }
}

