/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NoriPartOfSpeechTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final List<String> stoptags;
    public static final JsonpDeserializer<NoriPartOfSpeechTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NoriPartOfSpeechTokenFilter::setupNoriPartOfSpeechTokenFilterDeserializer);

    private NoriPartOfSpeechTokenFilter(Builder builder) {
        super(builder);
        this.stoptags = ApiTypeHelper.unmodifiable(builder.stoptags);
    }

    public static NoriPartOfSpeechTokenFilter of(Function<Builder, ObjectBuilder<NoriPartOfSpeechTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.NoriPartOfSpeech;
    }

    public final List<String> stoptags() {
        return this.stoptags;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "nori_part_of_speech");
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.stoptags)) {
            generator.writeKey("stoptags");
            generator.writeStartArray();
            for (String item0 : this.stoptags) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupNoriPartOfSpeechTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::stoptags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stoptags");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<NoriPartOfSpeechTokenFilter> {
        @Nullable
        private List<String> stoptags;

        public Builder() {
        }

        private Builder(NoriPartOfSpeechTokenFilter instance) {
            this.stoptags = instance.stoptags;
        }

        public final Builder stoptags(List<String> list) {
            this.stoptags = Builder._listAddAll(this.stoptags, list);
            return this;
        }

        public final Builder stoptags(String value, String ... values) {
            this.stoptags = Builder._listAdd(this.stoptags, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NoriPartOfSpeechTokenFilter build() {
            this._checkSingleUse();
            return new NoriPartOfSpeechTokenFilter(this);
        }
    }
}

