/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.NumberPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ScaledFloatNumberProperty
extends NumberPropertyBase
implements PropertyVariant {
    @Nullable
    private final Double nullValue;
    @Nullable
    private final Double scalingFactor;
    public static final JsonpDeserializer<ScaledFloatNumberProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScaledFloatNumberProperty::setupScaledFloatNumberPropertyDeserializer);

    private ScaledFloatNumberProperty(Builder builder) {
        super(builder);
        this.nullValue = builder.nullValue;
        this.scalingFactor = builder.scalingFactor;
    }

    public static ScaledFloatNumberProperty of(Function<Builder, ObjectBuilder<ScaledFloatNumberProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.ScaledFloat;
    }

    @Nullable
    public final Double nullValue() {
        return this.nullValue;
    }

    @Nullable
    public final Double scalingFactor() {
        return this.scalingFactor;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "scaled_float");
        super.serializeInternal(generator, mapper);
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue.doubleValue());
        }
        if (this.scalingFactor != null) {
            generator.writeKey("scaling_factor");
            generator.write(this.scalingFactor.doubleValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupScaledFloatNumberPropertyDeserializer(ObjectDeserializer<Builder> op) {
        NumberPropertyBase.setupNumberPropertyBaseDeserializer(op);
        op.add(Builder::nullValue, JsonpDeserializer.doubleDeserializer(), "null_value");
        op.add(Builder::scalingFactor, JsonpDeserializer.doubleDeserializer(), "scaling_factor");
        op.ignore("type");
    }

    public static class Builder
    extends NumberPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ScaledFloatNumberProperty> {
        @Nullable
        private Double nullValue;
        @Nullable
        private Double scalingFactor;

        public Builder() {
        }

        private Builder(ScaledFloatNumberProperty instance) {
            this.nullValue = instance.nullValue;
            this.scalingFactor = instance.scalingFactor;
        }

        public final Builder nullValue(@Nullable Double value) {
            this.nullValue = value;
            return this;
        }

        public final Builder scalingFactor(@Nullable Double value) {
            this.scalingFactor = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ScaledFloatNumberProperty build() {
            this._checkSingleUse();
            return new ScaledFloatNumberProperty(this);
        }
    }
}

