/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanQueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SpanContainingQuery
extends QueryBase
implements SpanQueryVariant,
QueryVariant {
    private final SpanQuery big;
    private final SpanQuery little;
    public static final JsonpDeserializer<SpanContainingQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SpanContainingQuery::setupSpanContainingQueryDeserializer);

    private SpanContainingQuery(Builder builder) {
        super(builder);
        this.big = ApiTypeHelper.requireNonNull(builder.big, this, "big");
        this.little = ApiTypeHelper.requireNonNull(builder.little, this, "little");
    }

    public static SpanContainingQuery of(Function<Builder, ObjectBuilder<SpanContainingQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public SpanQuery.Kind _spanQueryKind() {
        return SpanQuery.Kind.SpanContaining;
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.SpanContaining;
    }

    public final SpanQuery big() {
        return this.big;
    }

    public final SpanQuery little() {
        return this.little;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("big");
        this.big.serialize(generator, mapper);
        generator.writeKey("little");
        this.little.serialize(generator, mapper);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSpanContainingQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::big, SpanQuery._DESERIALIZER, "big");
        op.add(Builder::little, SpanQuery._DESERIALIZER, "little");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SpanContainingQuery> {
        private SpanQuery big;
        private SpanQuery little;

        public Builder() {
        }

        private Builder(SpanContainingQuery instance) {
            this.big = instance.big;
            this.little = instance.little;
        }

        public final Builder big(SpanQuery value) {
            this.big = value;
            return this;
        }

        public final Builder big(Function<SpanQuery.Builder, ObjectBuilder<SpanQuery>> fn) {
            return this.big(fn.apply(new SpanQuery.Builder()).build());
        }

        public final Builder big(SpanQueryVariant value) {
            this.big = value._toSpanQuery();
            return this;
        }

        public final Builder little(SpanQuery value) {
            this.little = value;
            return this;
        }

        public final Builder little(Function<SpanQuery.Builder, ObjectBuilder<SpanQuery>> fn) {
            return this.little(fn.apply(new SpanQuery.Builder()).build());
        }

        public final Builder little(SpanQueryVariant value) {
            this.little = value._toSpanQuery();
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SpanContainingQuery build() {
            this._checkSingleUse();
            return new SpanContainingQuery(this);
        }
    }
}

