/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.autoscaling;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.autoscaling.AutoscalingPolicy;
import co.elastic.clients.elasticsearch.autoscaling.PutAutoscalingPolicyResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutAutoscalingPolicyRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Time masterTimeout;
    private final String name;
    @Nullable
    private final Time timeout;
    private final AutoscalingPolicy policy;
    public static final JsonpDeserializer<PutAutoscalingPolicyRequest> _DESERIALIZER = PutAutoscalingPolicyRequest.createPutAutoscalingPolicyRequestDeserializer();
    public static final Endpoint<PutAutoscalingPolicyRequest, PutAutoscalingPolicyResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutAutoscalingPolicyRequest, PutAutoscalingPolicyResponse>("es/autoscaling.put_autoscaling_policy", request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_autoscaling");
            buf.append("/policy");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("name", request.name);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutAutoscalingPolicyResponse._DESERIALIZER);

    private PutAutoscalingPolicyRequest(Builder builder) {
        this.masterTimeout = builder.masterTimeout;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.timeout = builder.timeout;
        this.policy = ApiTypeHelper.requireNonNull(builder.policy, this, "policy");
    }

    public static PutAutoscalingPolicyRequest of(Function<Builder, ObjectBuilder<PutAutoscalingPolicyRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public final AutoscalingPolicy policy() {
        return this.policy;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.policy.serialize(generator, mapper);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static JsonpDeserializer<PutAutoscalingPolicyRequest> createPutAutoscalingPolicyRequestDeserializer() {
        JsonpDeserializer<AutoscalingPolicy> valueDeserializer = AutoscalingPolicy._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().policy((AutoscalingPolicy)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutAutoscalingPolicyRequest> {
        @Nullable
        private Time masterTimeout;
        private String name;
        @Nullable
        private Time timeout;
        private AutoscalingPolicy policy;

        public Builder() {
        }

        private Builder(PutAutoscalingPolicyRequest instance) {
            this.masterTimeout = instance.masterTimeout;
            this.name = instance.name;
            this.timeout = instance.timeout;
            this.policy = instance.policy;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder policy(AutoscalingPolicy value) {
            this.policy = value;
            return this;
        }

        public final Builder policy(Function<AutoscalingPolicy.Builder, ObjectBuilder<AutoscalingPolicy>> fn) {
            return this.policy(fn.apply(new AutoscalingPolicy.Builder()).build());
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            AutoscalingPolicy value = AutoscalingPolicy._DESERIALIZER.deserialize(parser, mapper);
            return this.policy(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutAutoscalingPolicyRequest build() {
            this._checkSingleUse();
            return new PutAutoscalingPolicyRequest(this);
        }
    }
}

