/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.Bytes;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.TimeUnit;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.CatSnapshotsColumn;
import co.elastic.clients.elasticsearch.cat.SnapshotsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SnapshotsRequest
extends CatRequestBase {
    @Nullable
    private final Bytes bytes;
    private final List<String> h;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Time masterTimeout;
    private final List<String> repository;
    private final List<String> s;
    @Nullable
    private final TimeUnit time;
    public static final Endpoint<SnapshotsRequest, SnapshotsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SnapshotsRequest, SnapshotsResponse>("es/cat.snapshots", request -> "GET", request -> {
        boolean _repository = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.repository())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/snapshots");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/snapshots");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.repository.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _repository = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.repository())) {
            propsSet |= true;
        }
        if (!propsSet) {
            // empty if block
        }
        if (propsSet) {
            params.put("repository", request.repository.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (ApiTypeHelper.isDefined(request.s)) {
            params.put("s", request.s.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.bytes != null) {
            params.put("bytes", request.bytes.jsonValue());
        }
        if (ApiTypeHelper.isDefined(request.h)) {
            params.put("h", request.h.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.time != null) {
            params.put("time", request.time.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, SnapshotsResponse._DESERIALIZER);

    private SnapshotsRequest(Builder builder) {
        this.bytes = builder.bytes;
        this.h = ApiTypeHelper.unmodifiable(builder.h);
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.masterTimeout = builder.masterTimeout;
        this.repository = ApiTypeHelper.unmodifiable(builder.repository);
        this.s = ApiTypeHelper.unmodifiable(builder.s);
        this.time = builder.time;
    }

    public static SnapshotsRequest of(Function<Builder, ObjectBuilder<SnapshotsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    public final List<String> h() {
        return this.h;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final List<String> repository() {
        return this.repository;
    }

    public final List<String> s() {
        return this.s;
    }

    @Nullable
    public final TimeUnit time() {
        return this.time;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SnapshotsRequest> {
        @Nullable
        private Bytes bytes;
        @Nullable
        private List<String> h;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private List<String> repository;
        @Nullable
        private List<String> s;
        @Nullable
        private TimeUnit time;

        public Builder() {
        }

        private Builder(SnapshotsRequest instance) {
            this.bytes = instance.bytes;
            this.h = instance.h;
            this.ignoreUnavailable = instance.ignoreUnavailable;
            this.masterTimeout = instance.masterTimeout;
            this.repository = instance.repository;
            this.s = instance.s;
            this.time = instance.time;
        }

        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        public final Builder h(List<String> list) {
            this.h = Builder._listAddAll(this.h, list);
            return this;
        }

        public final Builder h(String value, String ... values) {
            this.h = Builder._listAdd(this.h, value, values);
            return this;
        }

        public final Builder h(CatSnapshotsColumn value, CatSnapshotsColumn ... values) {
            this.h = Builder._listAdd(this.h, value.jsonValue(), (String[])Arrays.stream(values).map(CatSnapshotsColumn::jsonValue).toArray(String[]::new));
            return this;
        }

        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder repository(List<String> list) {
            this.repository = Builder._listAddAll(this.repository, list);
            return this;
        }

        public final Builder repository(String value, String ... values) {
            this.repository = Builder._listAdd(this.repository, value, values);
            return this;
        }

        public final Builder s(List<String> list) {
            this.s = Builder._listAddAll(this.s, list);
            return this;
        }

        public final Builder s(String value, String ... values) {
            this.s = Builder._listAdd(this.s, value, values);
            return this;
        }

        public final Builder time(@Nullable TimeUnit value) {
            this.time = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SnapshotsRequest build() {
            this._checkSingleUse();
            return new SnapshotsRequest(this);
        }
    }
}

