/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr.get_auto_follow_pattern;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AutoFollowPatternSummary
implements JsonpSerializable {
    private final boolean active;
    private final String remoteCluster;
    @Nullable
    private final String followIndexPattern;
    private final List<String> leaderIndexPatterns;
    private final List<String> leaderIndexExclusionPatterns;
    private final int maxOutstandingReadRequests;
    public static final JsonpDeserializer<AutoFollowPatternSummary> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AutoFollowPatternSummary::setupAutoFollowPatternSummaryDeserializer);

    private AutoFollowPatternSummary(Builder builder) {
        this.active = ApiTypeHelper.requireNonNull(builder.active, (Object)this, "active", false);
        this.remoteCluster = ApiTypeHelper.requireNonNull(builder.remoteCluster, this, "remoteCluster");
        this.followIndexPattern = builder.followIndexPattern;
        this.leaderIndexPatterns = ApiTypeHelper.unmodifiableRequired(builder.leaderIndexPatterns, (Object)this, "leaderIndexPatterns");
        this.leaderIndexExclusionPatterns = ApiTypeHelper.unmodifiableRequired(builder.leaderIndexExclusionPatterns, (Object)this, "leaderIndexExclusionPatterns");
        this.maxOutstandingReadRequests = ApiTypeHelper.requireNonNull(builder.maxOutstandingReadRequests, (Object)this, "maxOutstandingReadRequests", 0);
    }

    public static AutoFollowPatternSummary of(Function<Builder, ObjectBuilder<AutoFollowPatternSummary>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean active() {
        return this.active;
    }

    public final String remoteCluster() {
        return this.remoteCluster;
    }

    @Nullable
    public final String followIndexPattern() {
        return this.followIndexPattern;
    }

    public final List<String> leaderIndexPatterns() {
        return this.leaderIndexPatterns;
    }

    public final List<String> leaderIndexExclusionPatterns() {
        return this.leaderIndexExclusionPatterns;
    }

    public final int maxOutstandingReadRequests() {
        return this.maxOutstandingReadRequests;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("active");
        generator.write(this.active);
        generator.writeKey("remote_cluster");
        generator.write(this.remoteCluster);
        if (this.followIndexPattern != null) {
            generator.writeKey("follow_index_pattern");
            generator.write(this.followIndexPattern);
        }
        if (ApiTypeHelper.isDefined(this.leaderIndexPatterns)) {
            generator.writeKey("leader_index_patterns");
            generator.writeStartArray();
            for (String item0 : this.leaderIndexPatterns) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.leaderIndexExclusionPatterns)) {
            generator.writeKey("leader_index_exclusion_patterns");
            generator.writeStartArray();
            for (String item0 : this.leaderIndexExclusionPatterns) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("max_outstanding_read_requests");
        generator.write(this.maxOutstandingReadRequests);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupAutoFollowPatternSummaryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::active, JsonpDeserializer.booleanDeserializer(), "active");
        op.add(Builder::remoteCluster, JsonpDeserializer.stringDeserializer(), "remote_cluster");
        op.add(Builder::followIndexPattern, JsonpDeserializer.stringDeserializer(), "follow_index_pattern");
        op.add(Builder::leaderIndexPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "leader_index_patterns");
        op.add(Builder::leaderIndexExclusionPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "leader_index_exclusion_patterns");
        op.add(Builder::maxOutstandingReadRequests, JsonpDeserializer.integerDeserializer(), "max_outstanding_read_requests");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AutoFollowPatternSummary> {
        private Boolean active;
        private String remoteCluster;
        @Nullable
        private String followIndexPattern;
        private List<String> leaderIndexPatterns;
        private List<String> leaderIndexExclusionPatterns;
        private Integer maxOutstandingReadRequests;

        public Builder() {
        }

        private Builder(AutoFollowPatternSummary instance) {
            this.active = instance.active;
            this.remoteCluster = instance.remoteCluster;
            this.followIndexPattern = instance.followIndexPattern;
            this.leaderIndexPatterns = instance.leaderIndexPatterns;
            this.leaderIndexExclusionPatterns = instance.leaderIndexExclusionPatterns;
            this.maxOutstandingReadRequests = instance.maxOutstandingReadRequests;
        }

        public final Builder active(boolean value) {
            this.active = value;
            return this;
        }

        public final Builder remoteCluster(String value) {
            this.remoteCluster = value;
            return this;
        }

        public final Builder followIndexPattern(@Nullable String value) {
            this.followIndexPattern = value;
            return this;
        }

        public final Builder leaderIndexPatterns(List<String> list) {
            this.leaderIndexPatterns = Builder._listAddAll(this.leaderIndexPatterns, list);
            return this;
        }

        public final Builder leaderIndexPatterns(String value, String ... values) {
            this.leaderIndexPatterns = Builder._listAdd(this.leaderIndexPatterns, value, values);
            return this;
        }

        public final Builder leaderIndexExclusionPatterns(List<String> list) {
            this.leaderIndexExclusionPatterns = Builder._listAddAll(this.leaderIndexExclusionPatterns, list);
            return this;
        }

        public final Builder leaderIndexExclusionPatterns(String value, String ... values) {
            this.leaderIndexExclusionPatterns = Builder._listAdd(this.leaderIndexExclusionPatterns, value, values);
            return this;
        }

        public final Builder maxOutstandingReadRequests(int value) {
            this.maxOutstandingReadRequests = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AutoFollowPatternSummary build() {
            this._checkSingleUse();
            return new AutoFollowPatternSummary(this);
        }
    }
}

