/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ClusterShardMetrics
implements JsonpSerializable {
    private final double avg;
    private final double max;
    private final double min;
    public static final JsonpDeserializer<ClusterShardMetrics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterShardMetrics::setupClusterShardMetricsDeserializer);

    private ClusterShardMetrics(Builder builder) {
        this.avg = ApiTypeHelper.requireNonNull(builder.avg, (Object)this, "avg", 0.0);
        this.max = ApiTypeHelper.requireNonNull(builder.max, (Object)this, "max", 0.0);
        this.min = ApiTypeHelper.requireNonNull(builder.min, (Object)this, "min", 0.0);
    }

    public static ClusterShardMetrics of(Function<Builder, ObjectBuilder<ClusterShardMetrics>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final double avg() {
        return this.avg;
    }

    public final double max() {
        return this.max;
    }

    public final double min() {
        return this.min;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("avg");
        generator.write(this.avg);
        generator.writeKey("max");
        generator.write(this.max);
        generator.writeKey("min");
        generator.write(this.min);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupClusterShardMetricsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::avg, JsonpDeserializer.doubleDeserializer(), "avg");
        op.add(Builder::max, JsonpDeserializer.doubleDeserializer(), "max");
        op.add(Builder::min, JsonpDeserializer.doubleDeserializer(), "min");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ClusterShardMetrics> {
        private Double avg;
        private Double max;
        private Double min;

        public Builder() {
        }

        private Builder(ClusterShardMetrics instance) {
            this.avg = instance.avg;
            this.max = instance.max;
            this.min = instance.min;
        }

        public final Builder avg(double value) {
            this.avg = value;
            return this;
        }

        public final Builder max(double value) {
            this.max = value;
            return this;
        }

        public final Builder min(double value) {
            this.min = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClusterShardMetrics build() {
            this._checkSingleUse();
            return new ClusterShardMetrics(this);
        }
    }
}

