/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch.connector.FilteringPolicy;
import co.elastic.clients.elasticsearch.connector.FilteringRuleRule;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FilteringRule
implements JsonpSerializable {
    @Nullable
    private final DateTime createdAt;
    private final String field;
    private final String id;
    private final int order;
    private final FilteringPolicy policy;
    private final FilteringRuleRule rule;
    @Nullable
    private final DateTime updatedAt;
    private final String value;
    public static final JsonpDeserializer<FilteringRule> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FilteringRule::setupFilteringRuleDeserializer);

    private FilteringRule(Builder builder) {
        this.createdAt = builder.createdAt;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.order = ApiTypeHelper.requireNonNull(builder.order, (Object)this, "order", 0);
        this.policy = ApiTypeHelper.requireNonNull(builder.policy, this, "policy");
        this.rule = ApiTypeHelper.requireNonNull(builder.rule, this, "rule");
        this.updatedAt = builder.updatedAt;
        this.value = ApiTypeHelper.requireNonNull(builder.value, this, "value");
    }

    public static FilteringRule of(Function<Builder, ObjectBuilder<FilteringRule>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DateTime createdAt() {
        return this.createdAt;
    }

    public final String field() {
        return this.field;
    }

    public final String id() {
        return this.id;
    }

    public final int order() {
        return this.order;
    }

    public final FilteringPolicy policy() {
        return this.policy;
    }

    public final FilteringRuleRule rule() {
        return this.rule;
    }

    @Nullable
    public final DateTime updatedAt() {
        return this.updatedAt;
    }

    public final String value() {
        return this.value;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.createdAt != null) {
            generator.writeKey("created_at");
            this.createdAt.serialize(generator, mapper);
        }
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("order");
        generator.write(this.order);
        generator.writeKey("policy");
        this.policy.serialize(generator, mapper);
        generator.writeKey("rule");
        this.rule.serialize(generator, mapper);
        if (this.updatedAt != null) {
            generator.writeKey("updated_at");
            this.updatedAt.serialize(generator, mapper);
        }
        generator.writeKey("value");
        generator.write(this.value);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupFilteringRuleDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::createdAt, DateTime._DESERIALIZER, "created_at");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::order, JsonpDeserializer.integerDeserializer(), "order");
        op.add(Builder::policy, FilteringPolicy._DESERIALIZER, "policy");
        op.add(Builder::rule, FilteringRuleRule._DESERIALIZER, "rule");
        op.add(Builder::updatedAt, DateTime._DESERIALIZER, "updated_at");
        op.add(Builder::value, JsonpDeserializer.stringDeserializer(), "value");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FilteringRule> {
        @Nullable
        private DateTime createdAt;
        private String field;
        private String id;
        private Integer order;
        private FilteringPolicy policy;
        private FilteringRuleRule rule;
        @Nullable
        private DateTime updatedAt;
        private String value;

        public Builder() {
        }

        private Builder(FilteringRule instance) {
            this.createdAt = instance.createdAt;
            this.field = instance.field;
            this.id = instance.id;
            this.order = instance.order;
            this.policy = instance.policy;
            this.rule = instance.rule;
            this.updatedAt = instance.updatedAt;
            this.value = instance.value;
        }

        public final Builder createdAt(@Nullable DateTime value) {
            this.createdAt = value;
            return this;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder order(int value) {
            this.order = value;
            return this;
        }

        public final Builder policy(FilteringPolicy value) {
            this.policy = value;
            return this;
        }

        public final Builder rule(FilteringRuleRule value) {
            this.rule = value;
            return this;
        }

        public final Builder updatedAt(@Nullable DateTime value) {
            this.updatedAt = value;
            return this;
        }

        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FilteringRule build() {
            this._checkSingleUse();
            return new FilteringRule(this);
        }
    }
}

