/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SelectOption
implements JsonpSerializable {
    private final String label;
    private final FieldValue value;
    public static final JsonpDeserializer<SelectOption> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SelectOption::setupSelectOptionDeserializer);

    private SelectOption(Builder builder) {
        this.label = ApiTypeHelper.requireNonNull(builder.label, this, "label");
        this.value = ApiTypeHelper.requireNonNull(builder.value, this, "value");
    }

    public static SelectOption of(Function<Builder, ObjectBuilder<SelectOption>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String label() {
        return this.label;
    }

    public final FieldValue value() {
        return this.value;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("label");
        generator.write(this.label);
        generator.writeKey("value");
        this.value.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSelectOptionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::label, JsonpDeserializer.stringDeserializer(), "label");
        op.add(Builder::value, FieldValue._DESERIALIZER, "value");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SelectOption> {
        private String label;
        private FieldValue value;

        public Builder() {
        }

        private Builder(SelectOption instance) {
            this.label = instance.label;
            this.value = instance.value;
        }

        public final Builder label(String value) {
            this.label = value;
            return this;
        }

        public final Builder value(FieldValue value) {
            this.value = value;
            return this;
        }

        public final Builder value(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.value(fn.apply(new FieldValue.Builder()).build());
        }

        public final Builder value(String value) {
            this.value = FieldValue.of(value);
            return this;
        }

        public final Builder value(long value) {
            this.value = FieldValue.of(value);
            return this;
        }

        public final Builder value(double value) {
            this.value = FieldValue.of(value);
            return this;
        }

        public final Builder value(boolean value) {
            this.value = FieldValue.of(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SelectOption build() {
            this._checkSingleUse();
            return new SelectOption(this);
        }
    }
}

