/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.connector.UpdateServiceTypeResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;

@JsonpDeserializable
public class UpdateServiceTypeRequest
extends RequestBase
implements JsonpSerializable {
    private final String connectorId;
    private final String serviceType;
    public static final JsonpDeserializer<UpdateServiceTypeRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateServiceTypeRequest::setupUpdateServiceTypeRequestDeserializer);
    public static final Endpoint<UpdateServiceTypeRequest, UpdateServiceTypeResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateServiceTypeRequest, UpdateServiceTypeResponse>("es/connector.update_service_type", request -> "PUT", request -> {
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_connector");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.connectorId, buf);
            buf.append("/_service_type");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("connectorId", request.connectorId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateServiceTypeResponse._DESERIALIZER);

    private UpdateServiceTypeRequest(Builder builder) {
        this.connectorId = ApiTypeHelper.requireNonNull(builder.connectorId, this, "connectorId");
        this.serviceType = ApiTypeHelper.requireNonNull(builder.serviceType, this, "serviceType");
    }

    public static UpdateServiceTypeRequest of(Function<Builder, ObjectBuilder<UpdateServiceTypeRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String connectorId() {
        return this.connectorId;
    }

    public final String serviceType() {
        return this.serviceType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("service_type");
        generator.write(this.serviceType);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupUpdateServiceTypeRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::serviceType, JsonpDeserializer.stringDeserializer(), "service_type");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UpdateServiceTypeRequest> {
        private String connectorId;
        private String serviceType;

        public Builder() {
        }

        private Builder(UpdateServiceTypeRequest instance) {
            this.connectorId = instance.connectorId;
            this.serviceType = instance.serviceType;
        }

        public final Builder connectorId(String value) {
            this.connectorId = value;
            return this;
        }

        public final Builder serviceType(String value) {
            this.serviceType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateServiceTypeRequest build() {
            this._checkSingleUse();
            return new UpdateServiceTypeRequest(this);
        }
    }
}

