/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.elasticsearch.core.MtermvectorsResponse;
import co.elastic.clients.elasticsearch.core.mtermvectors.MultiTermVectorsOperation;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MtermvectorsRequest
extends RequestBase
implements JsonpSerializable {
    private final List<MultiTermVectorsOperation> docs;
    @Nullable
    private final Boolean fieldStatistics;
    private final List<String> fields;
    private final List<String> ids;
    @Nullable
    private final String index;
    @Nullable
    private final Boolean offsets;
    @Nullable
    private final Boolean payloads;
    @Nullable
    private final Boolean positions;
    @Nullable
    private final String preference;
    @Nullable
    private final Boolean realtime;
    private final List<String> routing;
    @Nullable
    private final Boolean termStatistics;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    public static final JsonpDeserializer<MtermvectorsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MtermvectorsRequest::setupMtermvectorsRequestDeserializer);
    public static final Endpoint<MtermvectorsRequest, MtermvectorsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<MtermvectorsRequest, MtermvectorsResponse>("es/mtermvectors", request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (request.index() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_mtermvectors");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_mtermvectors");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _index = true;
        boolean propsSet = false;
        if (request.index() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            // empty if block
        }
        if (propsSet) {
            params.put("index", request.index);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (ApiTypeHelper.isDefined(request.routing)) {
            params.put("routing", request.routing.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.realtime != null) {
            params.put("realtime", String.valueOf(request.realtime));
        }
        if (request.termStatistics != null) {
            params.put("term_statistics", String.valueOf(request.termStatistics));
        }
        if (request.offsets != null) {
            params.put("offsets", String.valueOf(request.offsets));
        }
        if (request.payloads != null) {
            params.put("payloads", String.valueOf(request.payloads));
        }
        if (request.versionType != null) {
            params.put("version_type", request.versionType.jsonValue());
        }
        if (request.preference != null) {
            params.put("preference", request.preference);
        }
        if (request.positions != null) {
            params.put("positions", String.valueOf(request.positions));
        }
        if (request.fieldStatistics != null) {
            params.put("field_statistics", String.valueOf(request.fieldStatistics));
        }
        if (ApiTypeHelper.isDefined(request.fields)) {
            params.put("fields", request.fields.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.version != null) {
            params.put("version", String.valueOf(request.version));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, MtermvectorsResponse._DESERIALIZER);

    private MtermvectorsRequest(Builder builder) {
        this.docs = ApiTypeHelper.unmodifiable(builder.docs);
        this.fieldStatistics = builder.fieldStatistics;
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.ids = ApiTypeHelper.unmodifiable(builder.ids);
        this.index = builder.index;
        this.offsets = builder.offsets;
        this.payloads = builder.payloads;
        this.positions = builder.positions;
        this.preference = builder.preference;
        this.realtime = builder.realtime;
        this.routing = ApiTypeHelper.unmodifiable(builder.routing);
        this.termStatistics = builder.termStatistics;
        this.version = builder.version;
        this.versionType = builder.versionType;
    }

    public static MtermvectorsRequest of(Function<Builder, ObjectBuilder<MtermvectorsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<MultiTermVectorsOperation> docs() {
        return this.docs;
    }

    @Nullable
    public final Boolean fieldStatistics() {
        return this.fieldStatistics;
    }

    public final List<String> fields() {
        return this.fields;
    }

    public final List<String> ids() {
        return this.ids;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nullable
    public final Boolean offsets() {
        return this.offsets;
    }

    @Nullable
    public final Boolean payloads() {
        return this.payloads;
    }

    @Nullable
    public final Boolean positions() {
        return this.positions;
    }

    @Nullable
    public final String preference() {
        return this.preference;
    }

    @Nullable
    public final Boolean realtime() {
        return this.realtime;
    }

    public final List<String> routing() {
        return this.routing;
    }

    @Nullable
    public final Boolean termStatistics() {
        return this.termStatistics;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Nullable
    public final VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.docs)) {
            generator.writeKey("docs");
            generator.writeStartArray();
            for (MultiTermVectorsOperation multiTermVectorsOperation : this.docs) {
                multiTermVectorsOperation.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.ids)) {
            generator.writeKey("ids");
            generator.writeStartArray();
            for (String string : this.ids) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupMtermvectorsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::docs, JsonpDeserializer.arrayDeserializer(MultiTermVectorsOperation._DESERIALIZER), "docs");
        op.add(Builder::ids, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ids");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MtermvectorsRequest> {
        @Nullable
        private List<MultiTermVectorsOperation> docs;
        @Nullable
        private Boolean fieldStatistics;
        @Nullable
        private List<String> fields;
        @Nullable
        private List<String> ids;
        @Nullable
        private String index;
        @Nullable
        private Boolean offsets;
        @Nullable
        private Boolean payloads;
        @Nullable
        private Boolean positions;
        @Nullable
        private String preference;
        @Nullable
        private Boolean realtime;
        @Nullable
        private List<String> routing;
        @Nullable
        private Boolean termStatistics;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;

        public Builder() {
        }

        private Builder(MtermvectorsRequest instance) {
            this.docs = instance.docs;
            this.fieldStatistics = instance.fieldStatistics;
            this.fields = instance.fields;
            this.ids = instance.ids;
            this.index = instance.index;
            this.offsets = instance.offsets;
            this.payloads = instance.payloads;
            this.positions = instance.positions;
            this.preference = instance.preference;
            this.realtime = instance.realtime;
            this.routing = instance.routing;
            this.termStatistics = instance.termStatistics;
            this.version = instance.version;
            this.versionType = instance.versionType;
        }

        public final Builder docs(List<MultiTermVectorsOperation> list) {
            this.docs = Builder._listAddAll(this.docs, list);
            return this;
        }

        public final Builder docs(MultiTermVectorsOperation value, MultiTermVectorsOperation ... values) {
            this.docs = Builder._listAdd(this.docs, value, values);
            return this;
        }

        public final Builder docs(Function<MultiTermVectorsOperation.Builder, ObjectBuilder<MultiTermVectorsOperation>> fn) {
            return this.docs(fn.apply(new MultiTermVectorsOperation.Builder()).build(), new MultiTermVectorsOperation[0]);
        }

        public final Builder fieldStatistics(@Nullable Boolean value) {
            this.fieldStatistics = value;
            return this;
        }

        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder ids(List<String> list) {
            this.ids = Builder._listAddAll(this.ids, list);
            return this;
        }

        public final Builder ids(String value, String ... values) {
            this.ids = Builder._listAdd(this.ids, value, values);
            return this;
        }

        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public final Builder offsets(@Nullable Boolean value) {
            this.offsets = value;
            return this;
        }

        public final Builder payloads(@Nullable Boolean value) {
            this.payloads = value;
            return this;
        }

        public final Builder positions(@Nullable Boolean value) {
            this.positions = value;
            return this;
        }

        public final Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        public final Builder realtime(@Nullable Boolean value) {
            this.realtime = value;
            return this;
        }

        public final Builder routing(List<String> list) {
            this.routing = Builder._listAddAll(this.routing, list);
            return this;
        }

        public final Builder routing(String value, String ... values) {
            this.routing = Builder._listAdd(this.routing, value, values);
            return this;
        }

        public final Builder termStatistics(@Nullable Boolean value) {
            this.termStatistics = value;
            return this;
        }

        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public final Builder versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MtermvectorsRequest build() {
            this._checkSingleUse();
            return new MtermvectorsRequest(this);
        }
    }
}

