/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.WaitForActiveShards;
import co.elastic.clients.elasticsearch.core.UpdateResponse;
import co.elastic.clients.elasticsearch.core.search.SourceConfig;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.NamedDeserializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UpdateRequest<TDocument, TPartialDocument>
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final SourceConfig source;
    @Nullable
    private final Boolean detectNoop;
    @Nullable
    private final TPartialDocument doc;
    @Nullable
    private final Boolean docAsUpsert;
    private final String id;
    @Nullable
    private final Long ifPrimaryTerm;
    @Nullable
    private final Long ifSeqNo;
    @Nullable
    private final Boolean includeSourceOnError;
    private final String index;
    @Nullable
    private final String lang;
    @Nullable
    private final Refresh refresh;
    @Nullable
    private final Boolean requireAlias;
    @Nullable
    private final Integer retryOnConflict;
    private final List<String> routing;
    @Nullable
    private final Script script;
    @Nullable
    private final Boolean scriptedUpsert;
    @Nullable
    private final Time timeout;
    @Nullable
    private final TDocument upsert;
    @Nullable
    private final WaitForActiveShards waitForActiveShards;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    @Nullable
    private final JsonpSerializer<TPartialDocument> tPartialDocumentSerializer;
    public static final JsonpDeserializer<UpdateRequest<Object, Object>> _DESERIALIZER = JsonpDeserializer.lazy(() -> UpdateRequest.createUpdateRequestDeserializer(new NamedDeserializer("co.elastic.clients:Deserializer:_global.update.Request.TDocument"), new NamedDeserializer("co.elastic.clients:Deserializer:_global.update.Request.TPartialDocument")));
    public static final SimpleEndpoint<UpdateRequest<?, ?>, ?> _ENDPOINT = new SimpleEndpoint<UpdateRequest, UpdateResponse<Object>>("es/update", request -> "POST", request -> {
        boolean _index = true;
        int _id = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_update");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _index = true;
        int _id = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("index", request.index);
            params.put("id", request.id);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.includeSourceOnError != null) {
            params.put("include_source_on_error", String.valueOf(request.includeSourceOnError));
        }
        if (request.refresh != null) {
            params.put("refresh", request.refresh.jsonValue());
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        if (ApiTypeHelper.isDefined(request.routing)) {
            params.put("routing", request.routing.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.requireAlias != null) {
            params.put("require_alias", String.valueOf(request.requireAlias));
        }
        if (request.ifPrimaryTerm != null) {
            params.put("if_primary_term", String.valueOf(request.ifPrimaryTerm));
        }
        if (request.ifSeqNo != null) {
            params.put("if_seq_no", String.valueOf(request.ifSeqNo));
        }
        if (request.waitForActiveShards != null) {
            params.put("wait_for_active_shards", request.waitForActiveShards._toJsonString());
        }
        if (request.lang != null) {
            params.put("lang", request.lang);
        }
        if (request.retryOnConflict != null) {
            params.put("retry_on_conflict", String.valueOf(request.retryOnConflict));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, UpdateResponse._DESERIALIZER);

    private UpdateRequest(Builder<TDocument, TPartialDocument> builder) {
        this.source = builder.source;
        this.detectNoop = builder.detectNoop;
        this.doc = builder.doc;
        this.docAsUpsert = builder.docAsUpsert;
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.ifPrimaryTerm = builder.ifPrimaryTerm;
        this.ifSeqNo = builder.ifSeqNo;
        this.includeSourceOnError = builder.includeSourceOnError;
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.lang = builder.lang;
        this.refresh = builder.refresh;
        this.requireAlias = builder.requireAlias;
        this.retryOnConflict = builder.retryOnConflict;
        this.routing = ApiTypeHelper.unmodifiable(builder.routing);
        this.script = builder.script;
        this.scriptedUpsert = builder.scriptedUpsert;
        this.timeout = builder.timeout;
        this.upsert = builder.upsert;
        this.waitForActiveShards = builder.waitForActiveShards;
        this.tDocumentSerializer = builder.tDocumentSerializer;
        this.tPartialDocumentSerializer = builder.tPartialDocumentSerializer;
    }

    public static <TDocument, TPartialDocument> UpdateRequest<TDocument, TPartialDocument> of(Function<Builder<TDocument, TPartialDocument>, ObjectBuilder<UpdateRequest<TDocument, TPartialDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final SourceConfig source() {
        return this.source;
    }

    @Nullable
    public final Boolean detectNoop() {
        return this.detectNoop;
    }

    @Nullable
    public final TPartialDocument doc() {
        return this.doc;
    }

    @Nullable
    public final Boolean docAsUpsert() {
        return this.docAsUpsert;
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final Long ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    @Nullable
    public final Long ifSeqNo() {
        return this.ifSeqNo;
    }

    @Nullable
    public final Boolean includeSourceOnError() {
        return this.includeSourceOnError;
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final String lang() {
        return this.lang;
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    @Nullable
    public final Boolean requireAlias() {
        return this.requireAlias;
    }

    @Nullable
    public final Integer retryOnConflict() {
        return this.retryOnConflict;
    }

    public final List<String> routing() {
        return this.routing;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final Boolean scriptedUpsert() {
        return this.scriptedUpsert;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final TDocument upsert() {
        return this.upsert;
    }

    @Nullable
    public final WaitForActiveShards waitForActiveShards() {
        return this.waitForActiveShards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.source != null) {
            generator.writeKey("_source");
            this.source.serialize(generator, mapper);
        }
        if (this.detectNoop != null) {
            generator.writeKey("detect_noop");
            generator.write(this.detectNoop.booleanValue());
        }
        if (this.doc != null) {
            generator.writeKey("doc");
            JsonpUtils.serialize(this.doc, generator, this.tPartialDocumentSerializer, mapper);
        }
        if (this.docAsUpsert != null) {
            generator.writeKey("doc_as_upsert");
            generator.write(this.docAsUpsert.booleanValue());
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.scriptedUpsert != null) {
            generator.writeKey("scripted_upsert");
            generator.write(this.scriptedUpsert.booleanValue());
        }
        if (this.upsert != null) {
            generator.writeKey("upsert");
            JsonpUtils.serialize(this.upsert, generator, this.tDocumentSerializer, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static <TDocument, TPartialDocument> JsonpDeserializer<UpdateRequest<TDocument, TPartialDocument>> createUpdateRequestDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer, JsonpDeserializer<TPartialDocument> tPartialDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> UpdateRequest.setupUpdateRequestDeserializer(op, tDocumentDeserializer, tPartialDocumentDeserializer));
    }

    protected static <TDocument, TPartialDocument> void setupUpdateRequestDeserializer(ObjectDeserializer<Builder<TDocument, TPartialDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer, JsonpDeserializer<TPartialDocument> tPartialDocumentDeserializer) {
        op.add(Builder::source, SourceConfig._DESERIALIZER, "_source");
        op.add(Builder::detectNoop, JsonpDeserializer.booleanDeserializer(), "detect_noop");
        op.add(Builder::doc, tPartialDocumentDeserializer, "doc");
        op.add(Builder::docAsUpsert, JsonpDeserializer.booleanDeserializer(), "doc_as_upsert");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::scriptedUpsert, JsonpDeserializer.booleanDeserializer(), "scripted_upsert");
        op.add(Builder::upsert, tDocumentDeserializer, "upsert");
    }

    public static <TDocument> Endpoint<UpdateRequest<?, ?>, UpdateResponse<TDocument>, ErrorResponse> createUpdateEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return _ENDPOINT.withResponseDeserializer(UpdateResponse.createUpdateResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder<TDocument, TPartialDocument>
    extends RequestBase.AbstractBuilder<Builder<TDocument, TPartialDocument>>
    implements ObjectBuilder<UpdateRequest<TDocument, TPartialDocument>> {
        @Nullable
        private SourceConfig source;
        @Nullable
        private Boolean detectNoop;
        @Nullable
        private TPartialDocument doc;
        @Nullable
        private Boolean docAsUpsert;
        private String id;
        @Nullable
        private Long ifPrimaryTerm;
        @Nullable
        private Long ifSeqNo;
        @Nullable
        private Boolean includeSourceOnError;
        private String index;
        @Nullable
        private String lang;
        @Nullable
        private Refresh refresh;
        @Nullable
        private Boolean requireAlias;
        @Nullable
        private Integer retryOnConflict;
        @Nullable
        private List<String> routing;
        @Nullable
        private Script script;
        @Nullable
        private Boolean scriptedUpsert;
        @Nullable
        private Time timeout;
        @Nullable
        private TDocument upsert;
        @Nullable
        private WaitForActiveShards waitForActiveShards;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;
        @Nullable
        private JsonpSerializer<TPartialDocument> tPartialDocumentSerializer;

        public Builder() {
        }

        private Builder(UpdateRequest<TDocument, TPartialDocument> instance) {
            this.source = instance.source;
            this.detectNoop = instance.detectNoop;
            this.doc = instance.doc;
            this.docAsUpsert = instance.docAsUpsert;
            this.id = instance.id;
            this.ifPrimaryTerm = instance.ifPrimaryTerm;
            this.ifSeqNo = instance.ifSeqNo;
            this.includeSourceOnError = instance.includeSourceOnError;
            this.index = instance.index;
            this.lang = instance.lang;
            this.refresh = instance.refresh;
            this.requireAlias = instance.requireAlias;
            this.retryOnConflict = instance.retryOnConflict;
            this.routing = instance.routing;
            this.script = instance.script;
            this.scriptedUpsert = instance.scriptedUpsert;
            this.timeout = instance.timeout;
            this.upsert = instance.upsert;
            this.waitForActiveShards = instance.waitForActiveShards;
        }

        public final Builder<TDocument, TPartialDocument> source(@Nullable SourceConfig value) {
            this.source = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> source(Function<SourceConfig.Builder, ObjectBuilder<SourceConfig>> fn) {
            return this.source(fn.apply(new SourceConfig.Builder()).build());
        }

        public final Builder<TDocument, TPartialDocument> detectNoop(@Nullable Boolean value) {
            this.detectNoop = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> doc(@Nullable TPartialDocument value) {
            this.doc = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> docAsUpsert(@Nullable Boolean value) {
            this.docAsUpsert = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> id(String value) {
            this.id = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> ifPrimaryTerm(@Nullable Long value) {
            this.ifPrimaryTerm = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> ifSeqNo(@Nullable Long value) {
            this.ifSeqNo = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> includeSourceOnError(@Nullable Boolean value) {
            this.includeSourceOnError = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> index(String value) {
            this.index = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> lang(@Nullable String value) {
            this.lang = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> requireAlias(@Nullable Boolean value) {
            this.requireAlias = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> retryOnConflict(@Nullable Integer value) {
            this.retryOnConflict = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> routing(List<String> list) {
            this.routing = Builder._listAddAll(this.routing, list);
            return this;
        }

        public final Builder<TDocument, TPartialDocument> routing(String value, String ... values) {
            this.routing = Builder._listAdd(this.routing, value, values);
            return this;
        }

        public final Builder<TDocument, TPartialDocument> script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final Builder<TDocument, TPartialDocument> scriptedUpsert(@Nullable Boolean value) {
            this.scriptedUpsert = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder<TDocument, TPartialDocument> upsert(@Nullable TDocument value) {
            this.upsert = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> waitForActiveShards(@Nullable WaitForActiveShards value) {
            this.waitForActiveShards = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> waitForActiveShards(Function<WaitForActiveShards.Builder, ObjectBuilder<WaitForActiveShards>> fn) {
            return this.waitForActiveShards(fn.apply(new WaitForActiveShards.Builder()).build());
        }

        public final Builder<TDocument, TPartialDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> tPartialDocumentSerializer(@Nullable JsonpSerializer<TPartialDocument> value) {
            this.tPartialDocumentSerializer = value;
            return this;
        }

        @Override
        protected Builder<TDocument, TPartialDocument> self() {
            return this;
        }

        @Override
        public UpdateRequest<TDocument, TPartialDocument> build() {
            this._checkSingleUse();
            return new UpdateRequest(this);
        }
    }
}

