/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.Collector;
import co.elastic.clients.elasticsearch.core.search.QueryProfile;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class SearchProfile
implements JsonpSerializable {
    private final List<Collector> collector;
    private final List<QueryProfile> query;
    private final long rewriteTime;
    public static final JsonpDeserializer<SearchProfile> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchProfile::setupSearchProfileDeserializer);

    private SearchProfile(Builder builder) {
        this.collector = ApiTypeHelper.unmodifiableRequired(builder.collector, (Object)this, "collector");
        this.query = ApiTypeHelper.unmodifiableRequired(builder.query, (Object)this, "query");
        this.rewriteTime = ApiTypeHelper.requireNonNull(builder.rewriteTime, (Object)this, "rewriteTime", 0L);
    }

    public static SearchProfile of(Function<Builder, ObjectBuilder<SearchProfile>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Collector> collector() {
        return this.collector;
    }

    public final List<QueryProfile> query() {
        return this.query;
    }

    public final long rewriteTime() {
        return this.rewriteTime;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.collector)) {
            generator.writeKey("collector");
            generator.writeStartArray();
            for (Collector collector : this.collector) {
                collector.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.query)) {
            generator.writeKey("query");
            generator.writeStartArray();
            for (QueryProfile queryProfile : this.query) {
                queryProfile.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("rewrite_time");
        generator.write(this.rewriteTime);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSearchProfileDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::collector, JsonpDeserializer.arrayDeserializer(Collector._DESERIALIZER), "collector");
        op.add(Builder::query, JsonpDeserializer.arrayDeserializer(QueryProfile._DESERIALIZER), "query");
        op.add(Builder::rewriteTime, JsonpDeserializer.longDeserializer(), "rewrite_time");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SearchProfile> {
        private List<Collector> collector;
        private List<QueryProfile> query;
        private Long rewriteTime;

        public Builder() {
        }

        private Builder(SearchProfile instance) {
            this.collector = instance.collector;
            this.query = instance.query;
            this.rewriteTime = instance.rewriteTime;
        }

        public final Builder collector(List<Collector> list) {
            this.collector = Builder._listAddAll(this.collector, list);
            return this;
        }

        public final Builder collector(Collector value, Collector ... values) {
            this.collector = Builder._listAdd(this.collector, value, values);
            return this;
        }

        public final Builder collector(Function<Collector.Builder, ObjectBuilder<Collector>> fn) {
            return this.collector(fn.apply(new Collector.Builder()).build(), new Collector[0]);
        }

        public final Builder query(List<QueryProfile> list) {
            this.query = Builder._listAddAll(this.query, list);
            return this;
        }

        public final Builder query(QueryProfile value, QueryProfile ... values) {
            this.query = Builder._listAdd(this.query, value, values);
            return this;
        }

        public final Builder query(Function<QueryProfile.Builder, ObjectBuilder<QueryProfile>> fn) {
            return this.query(fn.apply(new QueryProfile.Builder()).build(), new QueryProfile[0]);
        }

        public final Builder rewriteTime(long value) {
            this.rewriteTime = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SearchProfile build() {
            this._checkSingleUse();
            return new SearchProfile(this);
        }
    }
}

