/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RolloverAction
implements JsonpSerializable {
    @Nullable
    private final String maxSize;
    @Nullable
    private final String maxPrimaryShardSize;
    @Nullable
    private final Time maxAge;
    @Nullable
    private final Long maxDocs;
    @Nullable
    private final Long maxPrimaryShardDocs;
    @Nullable
    private final String minSize;
    @Nullable
    private final String minPrimaryShardSize;
    @Nullable
    private final Time minAge;
    @Nullable
    private final Long minDocs;
    @Nullable
    private final Long minPrimaryShardDocs;
    public static final JsonpDeserializer<RolloverAction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RolloverAction::setupRolloverActionDeserializer);

    private RolloverAction(Builder builder) {
        this.maxSize = builder.maxSize;
        this.maxPrimaryShardSize = builder.maxPrimaryShardSize;
        this.maxAge = builder.maxAge;
        this.maxDocs = builder.maxDocs;
        this.maxPrimaryShardDocs = builder.maxPrimaryShardDocs;
        this.minSize = builder.minSize;
        this.minPrimaryShardSize = builder.minPrimaryShardSize;
        this.minAge = builder.minAge;
        this.minDocs = builder.minDocs;
        this.minPrimaryShardDocs = builder.minPrimaryShardDocs;
    }

    public static RolloverAction of(Function<Builder, ObjectBuilder<RolloverAction>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Deprecated
    @Nullable
    public final String maxSize() {
        return this.maxSize;
    }

    @Nullable
    public final String maxPrimaryShardSize() {
        return this.maxPrimaryShardSize;
    }

    @Nullable
    public final Time maxAge() {
        return this.maxAge;
    }

    @Nullable
    public final Long maxDocs() {
        return this.maxDocs;
    }

    @Nullable
    public final Long maxPrimaryShardDocs() {
        return this.maxPrimaryShardDocs;
    }

    @Nullable
    public final String minSize() {
        return this.minSize;
    }

    @Nullable
    public final String minPrimaryShardSize() {
        return this.minPrimaryShardSize;
    }

    @Nullable
    public final Time minAge() {
        return this.minAge;
    }

    @Nullable
    public final Long minDocs() {
        return this.minDocs;
    }

    @Nullable
    public final Long minPrimaryShardDocs() {
        return this.minPrimaryShardDocs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.maxSize != null) {
            generator.writeKey("max_size");
            generator.write(this.maxSize);
        }
        if (this.maxPrimaryShardSize != null) {
            generator.writeKey("max_primary_shard_size");
            generator.write(this.maxPrimaryShardSize);
        }
        if (this.maxAge != null) {
            generator.writeKey("max_age");
            this.maxAge.serialize(generator, mapper);
        }
        if (this.maxDocs != null) {
            generator.writeKey("max_docs");
            generator.write(this.maxDocs.longValue());
        }
        if (this.maxPrimaryShardDocs != null) {
            generator.writeKey("max_primary_shard_docs");
            generator.write(this.maxPrimaryShardDocs.longValue());
        }
        if (this.minSize != null) {
            generator.writeKey("min_size");
            generator.write(this.minSize);
        }
        if (this.minPrimaryShardSize != null) {
            generator.writeKey("min_primary_shard_size");
            generator.write(this.minPrimaryShardSize);
        }
        if (this.minAge != null) {
            generator.writeKey("min_age");
            this.minAge.serialize(generator, mapper);
        }
        if (this.minDocs != null) {
            generator.writeKey("min_docs");
            generator.write(this.minDocs.longValue());
        }
        if (this.minPrimaryShardDocs != null) {
            generator.writeKey("min_primary_shard_docs");
            generator.write(this.minPrimaryShardDocs.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRolloverActionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxSize, JsonpDeserializer.stringDeserializer(), "max_size");
        op.add(Builder::maxPrimaryShardSize, JsonpDeserializer.stringDeserializer(), "max_primary_shard_size");
        op.add(Builder::maxAge, Time._DESERIALIZER, "max_age");
        op.add(Builder::maxDocs, JsonpDeserializer.longDeserializer(), "max_docs");
        op.add(Builder::maxPrimaryShardDocs, JsonpDeserializer.longDeserializer(), "max_primary_shard_docs");
        op.add(Builder::minSize, JsonpDeserializer.stringDeserializer(), "min_size");
        op.add(Builder::minPrimaryShardSize, JsonpDeserializer.stringDeserializer(), "min_primary_shard_size");
        op.add(Builder::minAge, Time._DESERIALIZER, "min_age");
        op.add(Builder::minDocs, JsonpDeserializer.longDeserializer(), "min_docs");
        op.add(Builder::minPrimaryShardDocs, JsonpDeserializer.longDeserializer(), "min_primary_shard_docs");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RolloverAction> {
        @Nullable
        private String maxSize;
        @Nullable
        private String maxPrimaryShardSize;
        @Nullable
        private Time maxAge;
        @Nullable
        private Long maxDocs;
        @Nullable
        private Long maxPrimaryShardDocs;
        @Nullable
        private String minSize;
        @Nullable
        private String minPrimaryShardSize;
        @Nullable
        private Time minAge;
        @Nullable
        private Long minDocs;
        @Nullable
        private Long minPrimaryShardDocs;

        public Builder() {
        }

        private Builder(RolloverAction instance) {
            this.maxSize = instance.maxSize;
            this.maxPrimaryShardSize = instance.maxPrimaryShardSize;
            this.maxAge = instance.maxAge;
            this.maxDocs = instance.maxDocs;
            this.maxPrimaryShardDocs = instance.maxPrimaryShardDocs;
            this.minSize = instance.minSize;
            this.minPrimaryShardSize = instance.minPrimaryShardSize;
            this.minAge = instance.minAge;
            this.minDocs = instance.minDocs;
            this.minPrimaryShardDocs = instance.minPrimaryShardDocs;
        }

        @Deprecated
        public final Builder maxSize(@Nullable String value) {
            this.maxSize = value;
            return this;
        }

        public final Builder maxPrimaryShardSize(@Nullable String value) {
            this.maxPrimaryShardSize = value;
            return this;
        }

        public final Builder maxAge(@Nullable Time value) {
            this.maxAge = value;
            return this;
        }

        public final Builder maxAge(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.maxAge(fn.apply(new Time.Builder()).build());
        }

        public final Builder maxDocs(@Nullable Long value) {
            this.maxDocs = value;
            return this;
        }

        public final Builder maxPrimaryShardDocs(@Nullable Long value) {
            this.maxPrimaryShardDocs = value;
            return this;
        }

        public final Builder minSize(@Nullable String value) {
            this.minSize = value;
            return this;
        }

        public final Builder minPrimaryShardSize(@Nullable String value) {
            this.minPrimaryShardSize = value;
            return this;
        }

        public final Builder minAge(@Nullable Time value) {
            this.minAge = value;
            return this;
        }

        public final Builder minAge(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.minAge(fn.apply(new Time.Builder()).build());
        }

        public final Builder minDocs(@Nullable Long value) {
            this.minDocs = value;
            return this;
        }

        public final Builder minPrimaryShardDocs(@Nullable Long value) {
            this.minPrimaryShardDocs = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RolloverAction build() {
            this._checkSingleUse();
            return new RolloverAction(this);
        }
    }
}

