/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Alias
implements JsonpSerializable {
    @Nullable
    private final Query filter;
    private final List<String> indexRouting;
    @Nullable
    private final Boolean isHidden;
    @Nullable
    private final Boolean isWriteIndex;
    private final List<String> routing;
    private final List<String> searchRouting;
    public static final JsonpDeserializer<Alias> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Alias::setupAliasDeserializer);

    private Alias(Builder builder) {
        this.filter = builder.filter;
        this.indexRouting = ApiTypeHelper.unmodifiable(builder.indexRouting);
        this.isHidden = builder.isHidden;
        this.isWriteIndex = builder.isWriteIndex;
        this.routing = ApiTypeHelper.unmodifiable(builder.routing);
        this.searchRouting = ApiTypeHelper.unmodifiable(builder.searchRouting);
    }

    public static Alias of(Function<Builder, ObjectBuilder<Alias>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Query filter() {
        return this.filter;
    }

    public final List<String> indexRouting() {
        return this.indexRouting;
    }

    @Nullable
    public final Boolean isHidden() {
        return this.isHidden;
    }

    @Nullable
    public final Boolean isWriteIndex() {
        return this.isWriteIndex;
    }

    public final List<String> routing() {
        return this.routing;
    }

    public final List<String> searchRouting() {
        return this.searchRouting;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.indexRouting)) {
            generator.writeKey("index_routing");
            generator.writeStartArray();
            for (String item0 : this.indexRouting) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.isHidden != null) {
            generator.writeKey("is_hidden");
            generator.write(this.isHidden.booleanValue());
        }
        if (this.isWriteIndex != null) {
            generator.writeKey("is_write_index");
            generator.write(this.isWriteIndex.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.routing)) {
            generator.writeKey("routing");
            generator.writeStartArray();
            for (String item0 : this.routing) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.searchRouting)) {
            generator.writeKey("search_routing");
            generator.writeStartArray();
            for (String item0 : this.searchRouting) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupAliasDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::filter, Query._DESERIALIZER, "filter");
        op.add(Builder::indexRouting, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index_routing");
        op.add(Builder::isHidden, JsonpDeserializer.booleanDeserializer(), "is_hidden");
        op.add(Builder::isWriteIndex, JsonpDeserializer.booleanDeserializer(), "is_write_index");
        op.add(Builder::routing, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "routing");
        op.add(Builder::searchRouting, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "search_routing");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Alias> {
        @Nullable
        private Query filter;
        @Nullable
        private List<String> indexRouting;
        @Nullable
        private Boolean isHidden;
        @Nullable
        private Boolean isWriteIndex;
        @Nullable
        private List<String> routing;
        @Nullable
        private List<String> searchRouting;

        public Builder() {
        }

        private Builder(Alias instance) {
            this.filter = instance.filter;
            this.indexRouting = instance.indexRouting;
            this.isHidden = instance.isHidden;
            this.isWriteIndex = instance.isWriteIndex;
            this.routing = instance.routing;
            this.searchRouting = instance.searchRouting;
        }

        public final Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        public final Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        public final Builder filter(QueryVariant value) {
            this.filter = value._toQuery();
            return this;
        }

        public final Builder indexRouting(List<String> list) {
            this.indexRouting = Builder._listAddAll(this.indexRouting, list);
            return this;
        }

        public final Builder indexRouting(String value, String ... values) {
            this.indexRouting = Builder._listAdd(this.indexRouting, value, values);
            return this;
        }

        public final Builder isHidden(@Nullable Boolean value) {
            this.isHidden = value;
            return this;
        }

        public final Builder isWriteIndex(@Nullable Boolean value) {
            this.isWriteIndex = value;
            return this;
        }

        public final Builder routing(List<String> list) {
            this.routing = Builder._listAddAll(this.routing, list);
            return this;
        }

        public final Builder routing(String value, String ... values) {
            this.routing = Builder._listAdd(this.routing, value, values);
            return this;
        }

        public final Builder searchRouting(List<String> list) {
            this.searchRouting = Builder._listAddAll(this.searchRouting, list);
            return this;
        }

        public final Builder searchRouting(String value, String ... values) {
            this.searchRouting = Builder._listAdd(this.searchRouting, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Alias build() {
            this._checkSingleUse();
            return new Alias(this);
        }
    }
}

