/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.indices.DataStreamFailureStore;
import co.elastic.clients.elasticsearch.indices.PutDataStreamOptionsResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutDataStreamOptionsRequest
extends RequestBase
implements JsonpSerializable {
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final DataStreamFailureStore failureStore;
    @Nullable
    private final Time masterTimeout;
    private final List<String> name;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutDataStreamOptionsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutDataStreamOptionsRequest::setupPutDataStreamOptionsRequestDeserializer);
    public static final Endpoint<PutDataStreamOptionsRequest, PutDataStreamOptionsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutDataStreamOptionsRequest, PutDataStreamOptionsResponse>("es/indices.put_data_stream_options", request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_data_stream");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_options");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("name", request.name.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutDataStreamOptionsResponse._DESERIALIZER);

    private PutDataStreamOptionsRequest(Builder builder) {
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.failureStore = builder.failureStore;
        this.masterTimeout = builder.masterTimeout;
        this.name = ApiTypeHelper.unmodifiableRequired(builder.name, (Object)this, "name");
        this.timeout = builder.timeout;
    }

    public static PutDataStreamOptionsRequest of(Function<Builder, ObjectBuilder<PutDataStreamOptionsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final DataStreamFailureStore failureStore() {
        return this.failureStore;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final List<String> name() {
        return this.name;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.failureStore != null) {
            generator.writeKey("failure_store");
            this.failureStore.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPutDataStreamOptionsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::failureStore, DataStreamFailureStore._DESERIALIZER, "failure_store");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutDataStreamOptionsRequest> {
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private DataStreamFailureStore failureStore;
        @Nullable
        private Time masterTimeout;
        private List<String> name;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(PutDataStreamOptionsRequest instance) {
            this.expandWildcards = instance.expandWildcards;
            this.failureStore = instance.failureStore;
            this.masterTimeout = instance.masterTimeout;
            this.name = instance.name;
            this.timeout = instance.timeout;
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder failureStore(@Nullable DataStreamFailureStore value) {
            this.failureStore = value;
            return this;
        }

        public final Builder failureStore(Function<DataStreamFailureStore.Builder, ObjectBuilder<DataStreamFailureStore>> fn) {
            return this.failureStore(fn.apply(new DataStreamFailureStore.Builder()).build());
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder name(List<String> list) {
            this.name = Builder._listAddAll(this.name, list);
            return this;
        }

        public final Builder name(String value, String ... values) {
            this.name = Builder._listAdd(this.name, value, values);
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutDataStreamOptionsRequest build() {
            this._checkSingleUse();
            return new PutDataStreamOptionsRequest(this);
        }
    }
}

