/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.field_usage_stats;

import co.elastic.clients.elasticsearch.indices.field_usage_stats.InvertedIndex;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class FieldSummary
implements JsonpSerializable {
    private final Number any;
    private final Number storedFields;
    private final Number docValues;
    private final Number points;
    private final Number norms;
    private final Number termVectors;
    private final Number knnVectors;
    private final InvertedIndex invertedIndex;
    public static final JsonpDeserializer<FieldSummary> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldSummary::setupFieldSummaryDeserializer);

    private FieldSummary(Builder builder) {
        this.any = ApiTypeHelper.requireNonNull(builder.any, this, "any");
        this.storedFields = ApiTypeHelper.requireNonNull(builder.storedFields, this, "storedFields");
        this.docValues = ApiTypeHelper.requireNonNull(builder.docValues, this, "docValues");
        this.points = ApiTypeHelper.requireNonNull(builder.points, this, "points");
        this.norms = ApiTypeHelper.requireNonNull(builder.norms, this, "norms");
        this.termVectors = ApiTypeHelper.requireNonNull(builder.termVectors, this, "termVectors");
        this.knnVectors = ApiTypeHelper.requireNonNull(builder.knnVectors, this, "knnVectors");
        this.invertedIndex = ApiTypeHelper.requireNonNull(builder.invertedIndex, this, "invertedIndex");
    }

    public static FieldSummary of(Function<Builder, ObjectBuilder<FieldSummary>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Number any() {
        return this.any;
    }

    public final Number storedFields() {
        return this.storedFields;
    }

    public final Number docValues() {
        return this.docValues;
    }

    public final Number points() {
        return this.points;
    }

    public final Number norms() {
        return this.norms;
    }

    public final Number termVectors() {
        return this.termVectors;
    }

    public final Number knnVectors() {
        return this.knnVectors;
    }

    public final InvertedIndex invertedIndex() {
        return this.invertedIndex;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("any");
        generator.write(this.any.doubleValue());
        generator.writeKey("stored_fields");
        generator.write(this.storedFields.doubleValue());
        generator.writeKey("doc_values");
        generator.write(this.docValues.doubleValue());
        generator.writeKey("points");
        generator.write(this.points.doubleValue());
        generator.writeKey("norms");
        generator.write(this.norms.doubleValue());
        generator.writeKey("term_vectors");
        generator.write(this.termVectors.doubleValue());
        generator.writeKey("knn_vectors");
        generator.write(this.knnVectors.doubleValue());
        generator.writeKey("inverted_index");
        this.invertedIndex.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupFieldSummaryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::any, JsonpDeserializer.numberDeserializer(), "any");
        op.add(Builder::storedFields, JsonpDeserializer.numberDeserializer(), "stored_fields");
        op.add(Builder::docValues, JsonpDeserializer.numberDeserializer(), "doc_values");
        op.add(Builder::points, JsonpDeserializer.numberDeserializer(), "points");
        op.add(Builder::norms, JsonpDeserializer.numberDeserializer(), "norms");
        op.add(Builder::termVectors, JsonpDeserializer.numberDeserializer(), "term_vectors");
        op.add(Builder::knnVectors, JsonpDeserializer.numberDeserializer(), "knn_vectors");
        op.add(Builder::invertedIndex, InvertedIndex._DESERIALIZER, "inverted_index");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FieldSummary> {
        private Number any;
        private Number storedFields;
        private Number docValues;
        private Number points;
        private Number norms;
        private Number termVectors;
        private Number knnVectors;
        private InvertedIndex invertedIndex;

        public Builder() {
        }

        private Builder(FieldSummary instance) {
            this.any = instance.any;
            this.storedFields = instance.storedFields;
            this.docValues = instance.docValues;
            this.points = instance.points;
            this.norms = instance.norms;
            this.termVectors = instance.termVectors;
            this.knnVectors = instance.knnVectors;
            this.invertedIndex = instance.invertedIndex;
        }

        public final Builder any(Number value) {
            this.any = value;
            return this;
        }

        public final Builder storedFields(Number value) {
            this.storedFields = value;
            return this;
        }

        public final Builder docValues(Number value) {
            this.docValues = value;
            return this;
        }

        public final Builder points(Number value) {
            this.points = value;
            return this;
        }

        public final Builder norms(Number value) {
            this.norms = value;
            return this;
        }

        public final Builder termVectors(Number value) {
            this.termVectors = value;
            return this;
        }

        public final Builder knnVectors(Number value) {
            this.knnVectors = value;
            return this;
        }

        public final Builder invertedIndex(InvertedIndex value) {
            this.invertedIndex = value;
            return this;
        }

        public final Builder invertedIndex(Function<InvertedIndex.Builder, ObjectBuilder<InvertedIndex>> fn) {
            return this.invertedIndex(fn.apply(new InvertedIndex.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FieldSummary build() {
            this._checkSingleUse();
            return new FieldSummary(this);
        }
    }
}

