/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.RateLimitSetting;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GroqServiceSettings
implements JsonpSerializable {
    private final String modelId;
    @Nullable
    private final String apiKey;
    @Nullable
    private final RateLimitSetting rateLimit;
    public static final JsonpDeserializer<GroqServiceSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GroqServiceSettings::setupGroqServiceSettingsDeserializer);

    private GroqServiceSettings(Builder builder) {
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.apiKey = builder.apiKey;
        this.rateLimit = builder.rateLimit;
    }

    public static GroqServiceSettings of(Function<Builder, ObjectBuilder<GroqServiceSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final String apiKey() {
        return this.apiKey;
    }

    @Nullable
    public final RateLimitSetting rateLimit() {
        return this.rateLimit;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("model_id");
        generator.write(this.modelId);
        if (this.apiKey != null) {
            generator.writeKey("api_key");
            generator.write(this.apiKey);
        }
        if (this.rateLimit != null) {
            generator.writeKey("rate_limit");
            this.rateLimit.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupGroqServiceSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::apiKey, JsonpDeserializer.stringDeserializer(), "api_key");
        op.add(Builder::rateLimit, RateLimitSetting._DESERIALIZER, "rate_limit");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GroqServiceSettings> {
        private String modelId;
        @Nullable
        private String apiKey;
        @Nullable
        private RateLimitSetting rateLimit;

        public Builder() {
        }

        private Builder(GroqServiceSettings instance) {
            this.modelId = instance.modelId;
            this.apiKey = instance.apiKey;
            this.rateLimit = instance.rateLimit;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder apiKey(@Nullable String value) {
            this.apiKey = value;
            return this;
        }

        public final Builder rateLimit(@Nullable RateLimitSetting value) {
            this.rateLimit = value;
            return this;
        }

        public final Builder rateLimit(Function<RateLimitSetting.Builder, ObjectBuilder<RateLimitSetting>> fn) {
            return this.rateLimit(fn.apply(new RateLimitSetting.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GroqServiceSettings build() {
            this._checkSingleUse();
            return new GroqServiceSettings(this);
        }
    }
}

