/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.LlamaSimilarityType;
import co.elastic.clients.elasticsearch.inference.RateLimitSetting;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class LlamaServiceSettings
implements JsonpSerializable {
    private final String url;
    private final String modelId;
    @Nullable
    private final Integer maxInputTokens;
    @Nullable
    private final LlamaSimilarityType similarity;
    @Nullable
    private final RateLimitSetting rateLimit;
    public static final JsonpDeserializer<LlamaServiceSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LlamaServiceSettings::setupLlamaServiceSettingsDeserializer);

    private LlamaServiceSettings(Builder builder) {
        this.url = ApiTypeHelper.requireNonNull(builder.url, this, "url");
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.maxInputTokens = builder.maxInputTokens;
        this.similarity = builder.similarity;
        this.rateLimit = builder.rateLimit;
    }

    public static LlamaServiceSettings of(Function<Builder, ObjectBuilder<LlamaServiceSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String url() {
        return this.url;
    }

    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final Integer maxInputTokens() {
        return this.maxInputTokens;
    }

    @Nullable
    public final LlamaSimilarityType similarity() {
        return this.similarity;
    }

    @Nullable
    public final RateLimitSetting rateLimit() {
        return this.rateLimit;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("url");
        generator.write(this.url);
        generator.writeKey("model_id");
        generator.write(this.modelId);
        if (this.maxInputTokens != null) {
            generator.writeKey("max_input_tokens");
            generator.write(this.maxInputTokens.intValue());
        }
        if (this.similarity != null) {
            generator.writeKey("similarity");
            this.similarity.serialize(generator, mapper);
        }
        if (this.rateLimit != null) {
            generator.writeKey("rate_limit");
            this.rateLimit.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupLlamaServiceSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::url, JsonpDeserializer.stringDeserializer(), "url");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::maxInputTokens, JsonpDeserializer.integerDeserializer(), "max_input_tokens");
        op.add(Builder::similarity, LlamaSimilarityType._DESERIALIZER, "similarity");
        op.add(Builder::rateLimit, RateLimitSetting._DESERIALIZER, "rate_limit");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<LlamaServiceSettings> {
        private String url;
        private String modelId;
        @Nullable
        private Integer maxInputTokens;
        @Nullable
        private LlamaSimilarityType similarity;
        @Nullable
        private RateLimitSetting rateLimit;

        public Builder() {
        }

        private Builder(LlamaServiceSettings instance) {
            this.url = instance.url;
            this.modelId = instance.modelId;
            this.maxInputTokens = instance.maxInputTokens;
            this.similarity = instance.similarity;
            this.rateLimit = instance.rateLimit;
        }

        public final Builder url(String value) {
            this.url = value;
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder maxInputTokens(@Nullable Integer value) {
            this.maxInputTokens = value;
            return this;
        }

        public final Builder similarity(@Nullable LlamaSimilarityType value) {
            this.similarity = value;
            return this;
        }

        public final Builder rateLimit(@Nullable RateLimitSetting value) {
            this.rateLimit = value;
            return this;
        }

        public final Builder rateLimit(Function<RateLimitSetting.Builder, ObjectBuilder<RateLimitSetting>> fn) {
            return this.rateLimit(fn.apply(new RateLimitSetting.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public LlamaServiceSettings build() {
            this._checkSingleUse();
            return new LlamaServiceSettings(this);
        }
    }
}

