/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.MessageContent;
import co.elastic.clients.elasticsearch.inference.ToolCall;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Message
implements JsonpSerializable {
    @Nullable
    private final MessageContent content;
    private final String role;
    @Nullable
    private final String toolCallId;
    private final List<ToolCall> toolCalls;
    public static final JsonpDeserializer<Message> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Message::setupMessageDeserializer);

    private Message(Builder builder) {
        this.content = builder.content;
        this.role = ApiTypeHelper.requireNonNull(builder.role, this, "role");
        this.toolCallId = builder.toolCallId;
        this.toolCalls = ApiTypeHelper.unmodifiable(builder.toolCalls);
    }

    public static Message of(Function<Builder, ObjectBuilder<Message>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final MessageContent content() {
        return this.content;
    }

    public final String role() {
        return this.role;
    }

    @Nullable
    public final String toolCallId() {
        return this.toolCallId;
    }

    public final List<ToolCall> toolCalls() {
        return this.toolCalls;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.content != null) {
            generator.writeKey("content");
            this.content.serialize(generator, mapper);
        }
        generator.writeKey("role");
        generator.write(this.role);
        if (this.toolCallId != null) {
            generator.writeKey("tool_call_id");
            generator.write(this.toolCallId);
        }
        if (ApiTypeHelper.isDefined(this.toolCalls)) {
            generator.writeKey("tool_calls");
            generator.writeStartArray();
            for (ToolCall item0 : this.toolCalls) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupMessageDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::content, MessageContent._DESERIALIZER, "content");
        op.add(Builder::role, JsonpDeserializer.stringDeserializer(), "role");
        op.add(Builder::toolCallId, JsonpDeserializer.stringDeserializer(), "tool_call_id");
        op.add(Builder::toolCalls, JsonpDeserializer.arrayDeserializer(ToolCall._DESERIALIZER), "tool_calls");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Message> {
        @Nullable
        private MessageContent content;
        private String role;
        @Nullable
        private String toolCallId;
        @Nullable
        private List<ToolCall> toolCalls;

        public Builder() {
        }

        private Builder(Message instance) {
            this.content = instance.content;
            this.role = instance.role;
            this.toolCallId = instance.toolCallId;
            this.toolCalls = instance.toolCalls;
        }

        public final Builder content(@Nullable MessageContent value) {
            this.content = value;
            return this;
        }

        public final Builder content(Function<MessageContent.Builder, ObjectBuilder<MessageContent>> fn) {
            return this.content(fn.apply(new MessageContent.Builder()).build());
        }

        public final Builder role(String value) {
            this.role = value;
            return this;
        }

        public final Builder toolCallId(@Nullable String value) {
            this.toolCallId = value;
            return this;
        }

        public final Builder toolCalls(List<ToolCall> list) {
            this.toolCalls = Builder._listAddAll(this.toolCalls, list);
            return this;
        }

        public final Builder toolCalls(ToolCall value, ToolCall ... values) {
            this.toolCalls = Builder._listAdd(this.toolCalls, value, values);
            return this;
        }

        public final Builder toolCalls(Function<ToolCall.Builder, ObjectBuilder<ToolCall>> fn) {
            return this.toolCalls(fn.apply(new ToolCall.Builder()).build(), new ToolCall[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Message build() {
            this._checkSingleUse();
            return new Message(this);
        }
    }
}

