/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.CohereTruncateType;
import co.elastic.clients.elasticsearch.inference.NvidiaInputType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NvidiaTaskSettings
implements JsonpSerializable {
    @Nullable
    private final NvidiaInputType inputType;
    @Nullable
    private final CohereTruncateType truncate;
    public static final JsonpDeserializer<NvidiaTaskSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NvidiaTaskSettings::setupNvidiaTaskSettingsDeserializer);

    private NvidiaTaskSettings(Builder builder) {
        this.inputType = builder.inputType;
        this.truncate = builder.truncate;
    }

    public static NvidiaTaskSettings of(Function<Builder, ObjectBuilder<NvidiaTaskSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final NvidiaInputType inputType() {
        return this.inputType;
    }

    @Nullable
    public final CohereTruncateType truncate() {
        return this.truncate;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.inputType != null) {
            generator.writeKey("input_type");
            this.inputType.serialize(generator, mapper);
        }
        if (this.truncate != null) {
            generator.writeKey("truncate");
            this.truncate.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupNvidiaTaskSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::inputType, NvidiaInputType._DESERIALIZER, "input_type");
        op.add(Builder::truncate, CohereTruncateType._DESERIALIZER, "truncate");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NvidiaTaskSettings> {
        @Nullable
        private NvidiaInputType inputType;
        @Nullable
        private CohereTruncateType truncate;

        public Builder() {
        }

        private Builder(NvidiaTaskSettings instance) {
            this.inputType = instance.inputType;
            this.truncate = instance.truncate;
        }

        public final Builder inputType(@Nullable NvidiaInputType value) {
            this.inputType = value;
            return this;
        }

        public final Builder truncate(@Nullable CohereTruncateType value) {
            this.truncate = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NvidiaTaskSettings build() {
            this._checkSingleUse();
            return new NvidiaTaskSettings(this);
        }
    }
}

