/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.inference.AzureOpenAIServiceSettings;
import co.elastic.clients.elasticsearch.inference.AzureOpenAIServiceType;
import co.elastic.clients.elasticsearch.inference.AzureOpenAITaskSettings;
import co.elastic.clients.elasticsearch.inference.AzureOpenAITaskType;
import co.elastic.clients.elasticsearch.inference.InferenceChunkingSettings;
import co.elastic.clients.elasticsearch.inference.PutAzureopenaiResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutAzureopenaiRequest
extends RequestBase
implements JsonpSerializable {
    private final String azureopenaiInferenceId;
    @Nullable
    private final InferenceChunkingSettings chunkingSettings;
    private final AzureOpenAIServiceType service;
    private final AzureOpenAIServiceSettings serviceSettings;
    @Nullable
    private final AzureOpenAITaskSettings taskSettings;
    private final AzureOpenAITaskType taskType;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutAzureopenaiRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutAzureopenaiRequest::setupPutAzureopenaiRequestDeserializer);
    public static final Endpoint<PutAzureopenaiRequest, PutAzureopenaiResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutAzureopenaiRequest, PutAzureopenaiResponse>("es/inference.put_azureopenai", request -> "PUT", request -> {
        boolean _azureopenaiInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.azureopenaiInferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _azureopenaiInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("azureopenaiInferenceId", request.azureopenaiInferenceId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutAzureopenaiResponse._DESERIALIZER);

    private PutAzureopenaiRequest(Builder builder) {
        this.azureopenaiInferenceId = ApiTypeHelper.requireNonNull(builder.azureopenaiInferenceId, this, "azureopenaiInferenceId");
        this.chunkingSettings = builder.chunkingSettings;
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskSettings = builder.taskSettings;
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
        this.timeout = builder.timeout;
    }

    public static PutAzureopenaiRequest of(Function<Builder, ObjectBuilder<PutAzureopenaiRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String azureopenaiInferenceId() {
        return this.azureopenaiInferenceId;
    }

    @Nullable
    public final InferenceChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    public final AzureOpenAIServiceType service() {
        return this.service;
    }

    public final AzureOpenAIServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    @Nullable
    public final AzureOpenAITaskSettings taskSettings() {
        return this.taskSettings;
    }

    public final AzureOpenAITaskType taskType() {
        return this.taskType;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkingSettings != null) {
            generator.writeKey("chunking_settings");
            this.chunkingSettings.serialize(generator, mapper);
        }
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
        if (this.taskSettings != null) {
            generator.writeKey("task_settings");
            this.taskSettings.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPutAzureopenaiRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunkingSettings, InferenceChunkingSettings._DESERIALIZER, "chunking_settings");
        op.add(Builder::service, AzureOpenAIServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, AzureOpenAIServiceSettings._DESERIALIZER, "service_settings");
        op.add(Builder::taskSettings, AzureOpenAITaskSettings._DESERIALIZER, "task_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutAzureopenaiRequest> {
        private String azureopenaiInferenceId;
        @Nullable
        private InferenceChunkingSettings chunkingSettings;
        private AzureOpenAIServiceType service;
        private AzureOpenAIServiceSettings serviceSettings;
        @Nullable
        private AzureOpenAITaskSettings taskSettings;
        private AzureOpenAITaskType taskType;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(PutAzureopenaiRequest instance) {
            this.azureopenaiInferenceId = instance.azureopenaiInferenceId;
            this.chunkingSettings = instance.chunkingSettings;
            this.service = instance.service;
            this.serviceSettings = instance.serviceSettings;
            this.taskSettings = instance.taskSettings;
            this.taskType = instance.taskType;
            this.timeout = instance.timeout;
        }

        public final Builder azureopenaiInferenceId(String value) {
            this.azureopenaiInferenceId = value;
            return this;
        }

        public final Builder chunkingSettings(@Nullable InferenceChunkingSettings value) {
            this.chunkingSettings = value;
            return this;
        }

        public final Builder chunkingSettings(Function<InferenceChunkingSettings.Builder, ObjectBuilder<InferenceChunkingSettings>> fn) {
            return this.chunkingSettings(fn.apply(new InferenceChunkingSettings.Builder()).build());
        }

        public final Builder service(AzureOpenAIServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(AzureOpenAIServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<AzureOpenAIServiceSettings.Builder, ObjectBuilder<AzureOpenAIServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new AzureOpenAIServiceSettings.Builder()).build());
        }

        public final Builder taskSettings(@Nullable AzureOpenAITaskSettings value) {
            this.taskSettings = value;
            return this;
        }

        public final Builder taskSettings(Function<AzureOpenAITaskSettings.Builder, ObjectBuilder<AzureOpenAITaskSettings>> fn) {
            return this.taskSettings(fn.apply(new AzureOpenAITaskSettings.Builder()).build());
        }

        public final Builder taskType(AzureOpenAITaskType value) {
            this.taskType = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutAzureopenaiRequest build() {
            this._checkSingleUse();
            return new PutAzureopenaiRequest(this);
        }
    }
}

