/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.inference.GroqServiceSettings;
import co.elastic.clients.elasticsearch.inference.GroqServiceType;
import co.elastic.clients.elasticsearch.inference.GroqTaskType;
import co.elastic.clients.elasticsearch.inference.PutGroqResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutGroqRequest
extends RequestBase
implements JsonpSerializable {
    private final String groqInferenceId;
    private final GroqServiceType service;
    private final GroqServiceSettings serviceSettings;
    private final GroqTaskType taskType;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutGroqRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutGroqRequest::setupPutGroqRequestDeserializer);
    public static final Endpoint<PutGroqRequest, PutGroqResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutGroqRequest, PutGroqResponse>("es/inference.put_groq", request -> "PUT", request -> {
        boolean _taskType = true;
        int _groqInferenceId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.groqInferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _taskType = true;
        int _groqInferenceId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("groqInferenceId", request.groqInferenceId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutGroqResponse._DESERIALIZER);

    private PutGroqRequest(Builder builder) {
        this.groqInferenceId = ApiTypeHelper.requireNonNull(builder.groqInferenceId, this, "groqInferenceId");
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
        this.timeout = builder.timeout;
    }

    public static PutGroqRequest of(Function<Builder, ObjectBuilder<PutGroqRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String groqInferenceId() {
        return this.groqInferenceId;
    }

    public final GroqServiceType service() {
        return this.service;
    }

    public final GroqServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    public final GroqTaskType taskType() {
        return this.taskType;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPutGroqRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::service, GroqServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, GroqServiceSettings._DESERIALIZER, "service_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutGroqRequest> {
        private String groqInferenceId;
        private GroqServiceType service;
        private GroqServiceSettings serviceSettings;
        private GroqTaskType taskType;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(PutGroqRequest instance) {
            this.groqInferenceId = instance.groqInferenceId;
            this.service = instance.service;
            this.serviceSettings = instance.serviceSettings;
            this.taskType = instance.taskType;
            this.timeout = instance.timeout;
        }

        public final Builder groqInferenceId(String value) {
            this.groqInferenceId = value;
            return this;
        }

        public final Builder service(GroqServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(GroqServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<GroqServiceSettings.Builder, ObjectBuilder<GroqServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new GroqServiceSettings.Builder()).build());
        }

        public final Builder taskType(GroqTaskType value) {
            this.taskType = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutGroqRequest build() {
            this._checkSingleUse();
            return new PutGroqRequest(this);
        }
    }
}

