/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.inference.InferenceEndpoint;
import co.elastic.clients.elasticsearch.inference.PutResponse;
import co.elastic.clients.elasticsearch.inference.TaskType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutRequest
extends RequestBase
implements JsonpSerializable {
    private final String inferenceId;
    @Nullable
    private final TaskType taskType;
    @Nullable
    private final Time timeout;
    private final InferenceEndpoint inferenceConfig;
    public static final JsonpDeserializer<PutRequest> _DESERIALIZER = PutRequest.createPutRequestDeserializer();
    public static final Endpoint<PutRequest, PutResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutRequest, PutResponse>("es/inference.put", request -> "PUT", request -> {
        boolean _inferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.taskType() != null) {
            propsSet |= 2;
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.inferenceId, buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.inferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _inferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.taskType() != null) {
            propsSet |= 2;
        }
        if (propsSet == 1) {
            params.put("inferenceId", request.inferenceId);
        }
        if (propsSet == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("inferenceId", request.inferenceId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutResponse._DESERIALIZER);

    private PutRequest(Builder builder) {
        this.inferenceId = ApiTypeHelper.requireNonNull(builder.inferenceId, this, "inferenceId");
        this.taskType = builder.taskType;
        this.timeout = builder.timeout;
        this.inferenceConfig = ApiTypeHelper.requireNonNull(builder.inferenceConfig, this, "inferenceConfig");
    }

    public static PutRequest of(Function<Builder, ObjectBuilder<PutRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String inferenceId() {
        return this.inferenceId;
    }

    @Nullable
    public final TaskType taskType() {
        return this.taskType;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public final InferenceEndpoint inferenceConfig() {
        return this.inferenceConfig;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.inferenceConfig.serialize(generator, mapper);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static JsonpDeserializer<PutRequest> createPutRequestDeserializer() {
        JsonpDeserializer<InferenceEndpoint> valueDeserializer = InferenceEndpoint._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().inferenceConfig((InferenceEndpoint)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutRequest> {
        private String inferenceId;
        @Nullable
        private TaskType taskType;
        @Nullable
        private Time timeout;
        private InferenceEndpoint inferenceConfig;

        public Builder() {
        }

        private Builder(PutRequest instance) {
            this.inferenceId = instance.inferenceId;
            this.taskType = instance.taskType;
            this.timeout = instance.timeout;
            this.inferenceConfig = instance.inferenceConfig;
        }

        public final Builder inferenceId(String value) {
            this.inferenceId = value;
            return this;
        }

        public final Builder taskType(@Nullable TaskType value) {
            this.taskType = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder inferenceConfig(InferenceEndpoint value) {
            this.inferenceConfig = value;
            return this;
        }

        public final Builder inferenceConfig(Function<InferenceEndpoint.Builder, ObjectBuilder<InferenceEndpoint>> fn) {
            return this.inferenceConfig(fn.apply(new InferenceEndpoint.Builder()).build());
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            InferenceEndpoint value = InferenceEndpoint._DESERIALIZER.deserialize(parser, mapper);
            return this.inferenceConfig(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutRequest build() {
            this._checkSingleUse();
            return new PutRequest(this);
        }
    }
}

