/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ingest.Maxmind;
import co.elastic.clients.elasticsearch.ingest.PutGeoipDatabaseResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutGeoipDatabaseRequest
extends RequestBase
implements JsonpSerializable {
    private final String id;
    @Nullable
    private final Time masterTimeout;
    private final Maxmind maxmind;
    private final String name;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutGeoipDatabaseRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutGeoipDatabaseRequest::setupPutGeoipDatabaseRequestDeserializer);
    public static final Endpoint<PutGeoipDatabaseRequest, PutGeoipDatabaseResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutGeoipDatabaseRequest, PutGeoipDatabaseResponse>("es/ingest.put_geoip_database", request -> "PUT", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ingest");
            buf.append("/geoip");
            buf.append("/database");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("id", request.id);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutGeoipDatabaseResponse._DESERIALIZER);

    private PutGeoipDatabaseRequest(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.masterTimeout = builder.masterTimeout;
        this.maxmind = ApiTypeHelper.requireNonNull(builder.maxmind, this, "maxmind");
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.timeout = builder.timeout;
    }

    public static PutGeoipDatabaseRequest of(Function<Builder, ObjectBuilder<PutGeoipDatabaseRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final Maxmind maxmind() {
        return this.maxmind;
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("maxmind");
        this.maxmind.serialize(generator, mapper);
        generator.writeKey("name");
        generator.write(this.name);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPutGeoipDatabaseRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxmind, Maxmind._DESERIALIZER, "maxmind");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutGeoipDatabaseRequest> {
        private String id;
        @Nullable
        private Time masterTimeout;
        private Maxmind maxmind;
        private String name;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(PutGeoipDatabaseRequest instance) {
            this.id = instance.id;
            this.masterTimeout = instance.masterTimeout;
            this.maxmind = instance.maxmind;
            this.name = instance.name;
            this.timeout = instance.timeout;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder maxmind(Maxmind value) {
            this.maxmind = value;
            return this;
        }

        public final Builder maxmind(Function<Maxmind.Builder, ObjectBuilder<Maxmind>> fn) {
            return this.maxmind(fn.apply(new Maxmind.Builder()).build());
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutGeoipDatabaseRequest build() {
            this._checkSingleUse();
            return new PutGeoipDatabaseRequest(this);
        }
    }
}

