/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RedactProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    private final List<String> patterns;
    private final Map<String, String> patternDefinitions;
    @Nullable
    private final String prefix;
    @Nullable
    private final String suffix;
    @Nullable
    private final Boolean ignoreMissing;
    @Nullable
    private final Boolean skipIfUnlicensed;
    @Nullable
    private final Boolean traceRedact;
    public static final JsonpDeserializer<RedactProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RedactProcessor::setupRedactProcessorDeserializer);

    private RedactProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.patterns = ApiTypeHelper.unmodifiableRequired(builder.patterns, (Object)this, "patterns");
        this.patternDefinitions = ApiTypeHelper.unmodifiable(builder.patternDefinitions);
        this.prefix = builder.prefix;
        this.suffix = builder.suffix;
        this.ignoreMissing = builder.ignoreMissing;
        this.skipIfUnlicensed = builder.skipIfUnlicensed;
        this.traceRedact = builder.traceRedact;
    }

    public static RedactProcessor of(Function<Builder, ObjectBuilder<RedactProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Redact;
    }

    public final String field() {
        return this.field;
    }

    public final List<String> patterns() {
        return this.patterns;
    }

    public final Map<String, String> patternDefinitions() {
        return this.patternDefinitions;
    }

    @Nullable
    public final String prefix() {
        return this.prefix;
    }

    @Nullable
    public final String suffix() {
        return this.suffix;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Nullable
    public final Boolean skipIfUnlicensed() {
        return this.skipIfUnlicensed;
    }

    @Nullable
    public final Boolean traceRedact() {
        return this.traceRedact;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (ApiTypeHelper.isDefined(this.patterns)) {
            generator.writeKey("patterns");
            generator.writeStartArray();
            for (String string : this.patterns) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.patternDefinitions)) {
            generator.writeKey("pattern_definitions");
            generator.writeStartObject();
            for (Map.Entry entry : this.patternDefinitions.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (this.prefix != null) {
            generator.writeKey("prefix");
            generator.write(this.prefix);
        }
        if (this.suffix != null) {
            generator.writeKey("suffix");
            generator.write(this.suffix);
        }
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        if (this.skipIfUnlicensed != null) {
            generator.writeKey("skip_if_unlicensed");
            generator.write(this.skipIfUnlicensed.booleanValue());
        }
        if (this.traceRedact != null) {
            generator.writeKey("trace_redact");
            generator.write(this.traceRedact.booleanValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRedactProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::patterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "patterns");
        op.add(Builder::patternDefinitions, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "pattern_definitions");
        op.add(Builder::prefix, JsonpDeserializer.stringDeserializer(), "prefix");
        op.add(Builder::suffix, JsonpDeserializer.stringDeserializer(), "suffix");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::skipIfUnlicensed, JsonpDeserializer.booleanDeserializer(), "skip_if_unlicensed");
        op.add(Builder::traceRedact, JsonpDeserializer.booleanDeserializer(), "trace_redact");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RedactProcessor> {
        private String field;
        private List<String> patterns;
        @Nullable
        private Map<String, String> patternDefinitions;
        @Nullable
        private String prefix;
        @Nullable
        private String suffix;
        @Nullable
        private Boolean ignoreMissing;
        @Nullable
        private Boolean skipIfUnlicensed;
        @Nullable
        private Boolean traceRedact;

        public Builder() {
        }

        private Builder(RedactProcessor instance) {
            this.field = instance.field;
            this.patterns = instance.patterns;
            this.patternDefinitions = instance.patternDefinitions;
            this.prefix = instance.prefix;
            this.suffix = instance.suffix;
            this.ignoreMissing = instance.ignoreMissing;
            this.skipIfUnlicensed = instance.skipIfUnlicensed;
            this.traceRedact = instance.traceRedact;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder patterns(List<String> list) {
            this.patterns = Builder._listAddAll(this.patterns, list);
            return this;
        }

        public final Builder patterns(String value, String ... values) {
            this.patterns = Builder._listAdd(this.patterns, value, values);
            return this;
        }

        public final Builder patternDefinitions(Map<String, String> map) {
            this.patternDefinitions = Builder._mapPutAll(this.patternDefinitions, map);
            return this;
        }

        public final Builder patternDefinitions(String key, String value) {
            this.patternDefinitions = Builder._mapPut(this.patternDefinitions, key, value);
            return this;
        }

        public final Builder prefix(@Nullable String value) {
            this.prefix = value;
            return this;
        }

        public final Builder suffix(@Nullable String value) {
            this.suffix = value;
            return this;
        }

        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public final Builder skipIfUnlicensed(@Nullable Boolean value) {
            this.skipIfUnlicensed = value;
            return this;
        }

        public final Builder traceRedact(@Nullable Boolean value) {
            this.traceRedact = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RedactProcessor build() {
            this._checkSingleUse();
            return new RedactProcessor(this);
        }
    }
}

