/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch.ingest.DocumentSimulation;
import co.elastic.clients.elasticsearch.ingest.PipelineProcessorResult;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SimulateDocumentResult
implements JsonpSerializable {
    @Nullable
    private final DocumentSimulation doc;
    @Nullable
    private final ErrorCause error;
    private final List<PipelineProcessorResult> processorResults;
    public static final JsonpDeserializer<SimulateDocumentResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SimulateDocumentResult::setupSimulateDocumentResultDeserializer);

    private SimulateDocumentResult(Builder builder) {
        this.doc = builder.doc;
        this.error = builder.error;
        this.processorResults = ApiTypeHelper.unmodifiable(builder.processorResults);
    }

    public static SimulateDocumentResult of(Function<Builder, ObjectBuilder<SimulateDocumentResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DocumentSimulation doc() {
        return this.doc;
    }

    @Nullable
    public final ErrorCause error() {
        return this.error;
    }

    public final List<PipelineProcessorResult> processorResults() {
        return this.processorResults;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.doc != null) {
            generator.writeKey("doc");
            this.doc.serialize(generator, mapper);
        }
        if (this.error != null) {
            generator.writeKey("error");
            this.error.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.processorResults)) {
            generator.writeKey("processor_results");
            generator.writeStartArray();
            for (PipelineProcessorResult item0 : this.processorResults) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSimulateDocumentResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::doc, DocumentSimulation._DESERIALIZER, "doc");
        op.add(Builder::error, ErrorCause._DESERIALIZER, "error");
        op.add(Builder::processorResults, JsonpDeserializer.arrayDeserializer(PipelineProcessorResult._DESERIALIZER), "processor_results");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SimulateDocumentResult> {
        @Nullable
        private DocumentSimulation doc;
        @Nullable
        private ErrorCause error;
        @Nullable
        private List<PipelineProcessorResult> processorResults;

        public Builder() {
        }

        private Builder(SimulateDocumentResult instance) {
            this.doc = instance.doc;
            this.error = instance.error;
            this.processorResults = instance.processorResults;
        }

        public final Builder doc(@Nullable DocumentSimulation value) {
            this.doc = value;
            return this;
        }

        public final Builder doc(Function<DocumentSimulation.Builder, ObjectBuilder<DocumentSimulation>> fn) {
            return this.doc(fn.apply(new DocumentSimulation.Builder()).build());
        }

        public final Builder error(@Nullable ErrorCause value) {
            this.error = value;
            return this;
        }

        public final Builder error(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.error(fn.apply(new ErrorCause.Builder()).build());
        }

        public final Builder processorResults(List<PipelineProcessorResult> list) {
            this.processorResults = Builder._listAddAll(this.processorResults, list);
            return this;
        }

        public final Builder processorResults(PipelineProcessorResult value, PipelineProcessorResult ... values) {
            this.processorResults = Builder._listAdd(this.processorResults, value, values);
            return this;
        }

        public final Builder processorResults(Function<PipelineProcessorResult.Builder, ObjectBuilder<PipelineProcessorResult>> fn) {
            return this.processorResults(fn.apply(new PipelineProcessorResult.Builder()).build(), new PipelineProcessorResult[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SimulateDocumentResult build() {
            this._checkSingleUse();
            return new SimulateDocumentResult(this);
        }
    }
}

