/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DataframeAnalyticsStatsDataCounts
implements JsonpSerializable {
    private final int skippedDocsCount;
    private final int testDocsCount;
    private final int trainingDocsCount;
    public static final JsonpDeserializer<DataframeAnalyticsStatsDataCounts> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeAnalyticsStatsDataCounts::setupDataframeAnalyticsStatsDataCountsDeserializer);

    private DataframeAnalyticsStatsDataCounts(Builder builder) {
        this.skippedDocsCount = ApiTypeHelper.requireNonNull(builder.skippedDocsCount, (Object)this, "skippedDocsCount", 0);
        this.testDocsCount = ApiTypeHelper.requireNonNull(builder.testDocsCount, (Object)this, "testDocsCount", 0);
        this.trainingDocsCount = ApiTypeHelper.requireNonNull(builder.trainingDocsCount, (Object)this, "trainingDocsCount", 0);
    }

    public static DataframeAnalyticsStatsDataCounts of(Function<Builder, ObjectBuilder<DataframeAnalyticsStatsDataCounts>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int skippedDocsCount() {
        return this.skippedDocsCount;
    }

    public final int testDocsCount() {
        return this.testDocsCount;
    }

    public final int trainingDocsCount() {
        return this.trainingDocsCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("skipped_docs_count");
        generator.write(this.skippedDocsCount);
        generator.writeKey("test_docs_count");
        generator.write(this.testDocsCount);
        generator.writeKey("training_docs_count");
        generator.write(this.trainingDocsCount);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDataframeAnalyticsStatsDataCountsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::skippedDocsCount, JsonpDeserializer.integerDeserializer(), "skipped_docs_count");
        op.add(Builder::testDocsCount, JsonpDeserializer.integerDeserializer(), "test_docs_count");
        op.add(Builder::trainingDocsCount, JsonpDeserializer.integerDeserializer(), "training_docs_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataframeAnalyticsStatsDataCounts> {
        private Integer skippedDocsCount;
        private Integer testDocsCount;
        private Integer trainingDocsCount;

        public Builder() {
        }

        private Builder(DataframeAnalyticsStatsDataCounts instance) {
            this.skippedDocsCount = instance.skippedDocsCount;
            this.testDocsCount = instance.testDocsCount;
            this.trainingDocsCount = instance.trainingDocsCount;
        }

        public final Builder skippedDocsCount(int value) {
            this.skippedDocsCount = value;
            return this;
        }

        public final Builder testDocsCount(int value) {
            this.testDocsCount = value;
            return this;
        }

        public final Builder trainingDocsCount(int value) {
            this.trainingDocsCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataframeAnalyticsStatsDataCounts build() {
            this._checkSingleUse();
            return new DataframeAnalyticsStatsDataCounts(this);
        }
    }
}

